package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteClusterMember invokes the edas.DeleteClusterMember API synchronously
func (client *Client) DeleteClusterMember(request *DeleteClusterMemberRequest) (response *DeleteClusterMemberResponse, err error) {
	response = CreateDeleteClusterMemberResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteClusterMemberWithChan invokes the edas.DeleteClusterMember API asynchronously
func (client *Client) DeleteClusterMemberWithChan(request *DeleteClusterMemberRequest) (<-chan *DeleteClusterMemberResponse, <-chan error) {
	responseChan := make(chan *DeleteClusterMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteClusterMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteClusterMemberWithCallback invokes the edas.DeleteClusterMember API asynchronously
func (client *Client) DeleteClusterMemberWithCallback(request *DeleteClusterMemberRequest, callback func(response *DeleteClusterMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteClusterMemberResponse
		var err error
		defer close(result)
		response, err = client.DeleteClusterMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteClusterMemberRequest is the request struct for api DeleteClusterMember
type DeleteClusterMemberRequest struct {
	*requests.RoaRequest
	ClusterMemberId string `position:"Query" name:"ClusterMemberId"`
	ClusterId       string `position:"Query" name:"ClusterId"`
}

// DeleteClusterMemberResponse is the response struct for api DeleteClusterMember
type DeleteClusterMemberResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteClusterMemberRequest creates a request to invoke DeleteClusterMember API
func CreateDeleteClusterMemberRequest() (request *DeleteClusterMemberRequest) {
	request = &DeleteClusterMemberRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DeleteClusterMember", "/pop/v5/resource/cluster_member", "Edas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteClusterMemberResponse creates a response to parse from DeleteClusterMember response
func CreateDeleteClusterMemberResponse() (response *DeleteClusterMemberResponse) {
	response = &DeleteClusterMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
