package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDiagnosticMetricSet invokes the ecs.CreateDiagnosticMetricSet API synchronously
func (client *Client) CreateDiagnosticMetricSet(request *CreateDiagnosticMetricSetRequest) (response *CreateDiagnosticMetricSetResponse, err error) {
	response = CreateCreateDiagnosticMetricSetResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDiagnosticMetricSetWithChan invokes the ecs.CreateDiagnosticMetricSet API asynchronously
func (client *Client) CreateDiagnosticMetricSetWithChan(request *CreateDiagnosticMetricSetRequest) (<-chan *CreateDiagnosticMetricSetResponse, <-chan error) {
	responseChan := make(chan *CreateDiagnosticMetricSetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDiagnosticMetricSet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDiagnosticMetricSetWithCallback invokes the ecs.CreateDiagnosticMetricSet API asynchronously
func (client *Client) CreateDiagnosticMetricSetWithCallback(request *CreateDiagnosticMetricSetRequest, callback func(response *CreateDiagnosticMetricSetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDiagnosticMetricSetResponse
		var err error
		defer close(result)
		response, err = client.CreateDiagnosticMetricSet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDiagnosticMetricSetRequest is the request struct for api CreateDiagnosticMetricSet
type CreateDiagnosticMetricSetRequest struct {
	*requests.RpcRequest
	MetricIds     *[]string `position:"Query" name:"MetricIds"  type:"Repeated"`
	Description   string    `position:"Query" name:"Description"`
	MetricSetName string    `position:"Query" name:"MetricSetName"`
	ResourceType  string    `position:"Query" name:"ResourceType"`
}

// CreateDiagnosticMetricSetResponse is the response struct for api CreateDiagnosticMetricSet
type CreateDiagnosticMetricSetResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	MetricSetId string `json:"MetricSetId" xml:"MetricSetId"`
}

// CreateCreateDiagnosticMetricSetRequest creates a request to invoke CreateDiagnosticMetricSet API
func CreateCreateDiagnosticMetricSetRequest() (request *CreateDiagnosticMetricSetRequest) {
	request = &CreateDiagnosticMetricSetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "CreateDiagnosticMetricSet", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDiagnosticMetricSetResponse creates a response to parse from CreateDiagnosticMetricSet response
func CreateCreateDiagnosticMetricSetResponse() (response *CreateDiagnosticMetricSetResponse) {
	response = &CreateDiagnosticMetricSetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
