package ecs_workbench

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ViewInstanceRecords invokes the ecs_workbench.ViewInstanceRecords API synchronously
func (client *Client) ViewInstanceRecords(request *ViewInstanceRecordsRequest) (response *ViewInstanceRecordsResponse, err error) {
	response = CreateViewInstanceRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// ViewInstanceRecordsWithChan invokes the ecs_workbench.ViewInstanceRecords API asynchronously
func (client *Client) ViewInstanceRecordsWithChan(request *ViewInstanceRecordsRequest) (<-chan *ViewInstanceRecordsResponse, <-chan error) {
	responseChan := make(chan *ViewInstanceRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ViewInstanceRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ViewInstanceRecordsWithCallback invokes the ecs_workbench.ViewInstanceRecords API asynchronously
func (client *Client) ViewInstanceRecordsWithCallback(request *ViewInstanceRecordsRequest, callback func(response *ViewInstanceRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ViewInstanceRecordsResponse
		var err error
		defer close(result)
		response, err = client.ViewInstanceRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ViewInstanceRecordsRequest is the request struct for api ViewInstanceRecords
type ViewInstanceRecordsRequest struct {
	*requests.RpcRequest
	InstanceId           string `position:"Body" name:"InstanceId"`
	TerminalSessionToken string `position:"Body" name:"TerminalSessionToken"`
}

// ViewInstanceRecordsResponse is the response struct for api ViewInstanceRecords
type ViewInstanceRecordsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Root      bool   `json:"Root" xml:"Root"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateViewInstanceRecordsRequest creates a request to invoke ViewInstanceRecords API
func CreateViewInstanceRecordsRequest() (request *ViewInstanceRecordsRequest) {
	request = &ViewInstanceRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecs-workbench", "2022-02-20", "ViewInstanceRecords", "ecs-workbench", "openAPI")
	request.Method = requests.POST
	return
}

// CreateViewInstanceRecordsResponse creates a response to parse from ViewInstanceRecords response
func CreateViewInstanceRecordsResponse() (response *ViewInstanceRecordsResponse) {
	response = &ViewInstanceRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
