//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package eci

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateContainerGroupFromTemplate invokes the eci.CreateContainerGroupFromTemplate API synchronously
// api document: https://help.aliyun.com/api/eci/createcontainergroupfromtemplate.html
func (client *Client) CreateContainerGroupFromTemplate(request *CreateContainerGroupFromTemplateRequest) (response *CreateContainerGroupFromTemplateResponse, err error) {
	response = CreateCreateContainerGroupFromTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// CreateContainerGroupFromTemplateWithChan invokes the eci.CreateContainerGroupFromTemplate API asynchronously
// api document: https://help.aliyun.com/api/eci/createcontainergroupfromtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateContainerGroupFromTemplateWithChan(request *CreateContainerGroupFromTemplateRequest) (<-chan *CreateContainerGroupFromTemplateResponse, <-chan error) {
	responseChan := make(chan *CreateContainerGroupFromTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateContainerGroupFromTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateContainerGroupFromTemplateWithCallback invokes the eci.CreateContainerGroupFromTemplate API asynchronously
// api document: https://help.aliyun.com/api/eci/createcontainergroupfromtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateContainerGroupFromTemplateWithCallback(request *CreateContainerGroupFromTemplateRequest, callback func(response *CreateContainerGroupFromTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateContainerGroupFromTemplateResponse
		var err error
		defer close(result)
		response, err = client.CreateContainerGroupFromTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateContainerGroupFromTemplateRequest is the request struct for api CreateContainerGroupFromTemplate
type CreateContainerGroupFromTemplateRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RegionId             string           `position:"Query" name:"RegionId"`
	Template             string           `position:"Body" name:"Template"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	VkClientVersion      string           `position:"Query" name:"VkClientVersion"`
}

// CreateContainerGroupFromTemplateResponse is the response struct for api CreateContainerGroupFromTemplate
type CreateContainerGroupFromTemplateResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	ContainerGroupId string `json:"ContainerGroupId" xml:"ContainerGroupId"`
}

// CreateCreateContainerGroupFromTemplateRequest creates a request to invoke CreateContainerGroupFromTemplate API
func CreateCreateContainerGroupFromTemplateRequest() (request *CreateContainerGroupFromTemplateRequest) {
	request = &CreateContainerGroupFromTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eci", "2018-08-08", "CreateContainerGroupFromTemplate", "eci", "openAPI")
	return
}

// CreateCreateContainerGroupFromTemplateResponse creates a response to parse from CreateContainerGroupFromTemplate response
func CreateCreateContainerGroupFromTemplateResponse() (response *CreateContainerGroupFromTemplateResponse) {
	response = &CreateContainerGroupFromTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
