package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RevokeCoordinatePrivilege invokes the ecd.RevokeCoordinatePrivilege API synchronously
func (client *Client) RevokeCoordinatePrivilege(request *RevokeCoordinatePrivilegeRequest) (response *RevokeCoordinatePrivilegeResponse, err error) {
	response = CreateRevokeCoordinatePrivilegeResponse()
	err = client.DoAction(request, response)
	return
}

// RevokeCoordinatePrivilegeWithChan invokes the ecd.RevokeCoordinatePrivilege API asynchronously
func (client *Client) RevokeCoordinatePrivilegeWithChan(request *RevokeCoordinatePrivilegeRequest) (<-chan *RevokeCoordinatePrivilegeResponse, <-chan error) {
	responseChan := make(chan *RevokeCoordinatePrivilegeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RevokeCoordinatePrivilege(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RevokeCoordinatePrivilegeWithCallback invokes the ecd.RevokeCoordinatePrivilege API asynchronously
func (client *Client) RevokeCoordinatePrivilegeWithCallback(request *RevokeCoordinatePrivilegeRequest, callback func(response *RevokeCoordinatePrivilegeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RevokeCoordinatePrivilegeResponse
		var err error
		defer close(result)
		response, err = client.RevokeCoordinatePrivilege(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RevokeCoordinatePrivilegeRequest is the request struct for api RevokeCoordinatePrivilege
type RevokeCoordinatePrivilegeRequest struct {
	*requests.RpcRequest
	CoId      string `position:"Query" name:"CoId"`
	UserType  string `position:"Query" name:"UserType"`
	Uuid      string `position:"Query" name:"Uuid"`
	EndUserId string `position:"Query" name:"EndUserId"`
}

// RevokeCoordinatePrivilegeResponse is the response struct for api RevokeCoordinatePrivilege
type RevokeCoordinatePrivilegeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRevokeCoordinatePrivilegeRequest creates a request to invoke RevokeCoordinatePrivilege API
func CreateRevokeCoordinatePrivilegeRequest() (request *RevokeCoordinatePrivilegeRequest) {
	request = &RevokeCoordinatePrivilegeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "RevokeCoordinatePrivilege", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRevokeCoordinatePrivilegeResponse creates a response to parse from RevokeCoordinatePrivilege response
func CreateRevokeCoordinatePrivilegeResponse() (response *RevokeCoordinatePrivilegeResponse) {
	response = &RevokeCoordinatePrivilegeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
