package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RenewDesktopGroup invokes the ecd.RenewDesktopGroup API synchronously
func (client *Client) RenewDesktopGroup(request *RenewDesktopGroupRequest) (response *RenewDesktopGroupResponse, err error) {
	response = CreateRenewDesktopGroupResponse()
	err = client.DoAction(request, response)
	return
}

// RenewDesktopGroupWithChan invokes the ecd.RenewDesktopGroup API asynchronously
func (client *Client) RenewDesktopGroupWithChan(request *RenewDesktopGroupRequest) (<-chan *RenewDesktopGroupResponse, <-chan error) {
	responseChan := make(chan *RenewDesktopGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RenewDesktopGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RenewDesktopGroupWithCallback invokes the ecd.RenewDesktopGroup API asynchronously
func (client *Client) RenewDesktopGroupWithCallback(request *RenewDesktopGroupRequest, callback func(response *RenewDesktopGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RenewDesktopGroupResponse
		var err error
		defer close(result)
		response, err = client.RenewDesktopGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RenewDesktopGroupRequest is the request struct for api RenewDesktopGroup
type RenewDesktopGroupRequest struct {
	*requests.RpcRequest
	Period         requests.Integer `position:"Query" name:"Period"`
	KeepSamePeriod requests.Integer `position:"Query" name:"KeepSamePeriod"`
	AutoPay        requests.Boolean `position:"Query" name:"AutoPay"`
	DesktopGroupId string           `position:"Query" name:"DesktopGroupId"`
	PeriodUnit     string           `position:"Query" name:"PeriodUnit"`
	AutoRenew      requests.Boolean `position:"Query" name:"AutoRenew"`
}

// RenewDesktopGroupResponse is the response struct for api RenewDesktopGroup
type RenewDesktopGroupResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	OrderId   []string `json:"OrderId" xml:"OrderId"`
}

// CreateRenewDesktopGroupRequest creates a request to invoke RenewDesktopGroup API
func CreateRenewDesktopGroupRequest() (request *RenewDesktopGroupRequest) {
	request = &RenewDesktopGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "RenewDesktopGroup", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRenewDesktopGroupResponse creates a response to parse from RenewDesktopGroup response
func CreateRenewDesktopGroupResponse() (response *RenewDesktopGroupResponse) {
	response = &RenewDesktopGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
