package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNetworkPackages invokes the ecd.DeleteNetworkPackages API synchronously
func (client *Client) DeleteNetworkPackages(request *DeleteNetworkPackagesRequest) (response *DeleteNetworkPackagesResponse, err error) {
	response = CreateDeleteNetworkPackagesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNetworkPackagesWithChan invokes the ecd.DeleteNetworkPackages API asynchronously
func (client *Client) DeleteNetworkPackagesWithChan(request *DeleteNetworkPackagesRequest) (<-chan *DeleteNetworkPackagesResponse, <-chan error) {
	responseChan := make(chan *DeleteNetworkPackagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNetworkPackages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNetworkPackagesWithCallback invokes the ecd.DeleteNetworkPackages API asynchronously
func (client *Client) DeleteNetworkPackagesWithCallback(request *DeleteNetworkPackagesRequest, callback func(response *DeleteNetworkPackagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNetworkPackagesResponse
		var err error
		defer close(result)
		response, err = client.DeleteNetworkPackages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNetworkPackagesRequest is the request struct for api DeleteNetworkPackages
type DeleteNetworkPackagesRequest struct {
	*requests.RpcRequest
	NetworkPackageId *[]string `position:"Query" name:"NetworkPackageId"  type:"Repeated"`
}

// DeleteNetworkPackagesResponse is the response struct for api DeleteNetworkPackages
type DeleteNetworkPackagesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteNetworkPackagesRequest creates a request to invoke DeleteNetworkPackages API
func CreateDeleteNetworkPackagesRequest() (request *DeleteNetworkPackagesRequest) {
	request = &DeleteNetworkPackagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DeleteNetworkPackages", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteNetworkPackagesResponse creates a response to parse from DeleteNetworkPackages response
func CreateDeleteNetworkPackagesResponse() (response *DeleteNetworkPackagesResponse) {
	response = &DeleteNetworkPackagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
