package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCloudDriveUsers invokes the ecd.DeleteCloudDriveUsers API synchronously
func (client *Client) DeleteCloudDriveUsers(request *DeleteCloudDriveUsersRequest) (response *DeleteCloudDriveUsersResponse, err error) {
	response = CreateDeleteCloudDriveUsersResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCloudDriveUsersWithChan invokes the ecd.DeleteCloudDriveUsers API asynchronously
func (client *Client) DeleteCloudDriveUsersWithChan(request *DeleteCloudDriveUsersRequest) (<-chan *DeleteCloudDriveUsersResponse, <-chan error) {
	responseChan := make(chan *DeleteCloudDriveUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCloudDriveUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCloudDriveUsersWithCallback invokes the ecd.DeleteCloudDriveUsers API asynchronously
func (client *Client) DeleteCloudDriveUsersWithCallback(request *DeleteCloudDriveUsersRequest, callback func(response *DeleteCloudDriveUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCloudDriveUsersResponse
		var err error
		defer close(result)
		response, err = client.DeleteCloudDriveUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCloudDriveUsersRequest is the request struct for api DeleteCloudDriveUsers
type DeleteCloudDriveUsersRequest struct {
	*requests.RpcRequest
	CdsId     string    `position:"Query" name:"CdsId"`
	EndUserId *[]string `position:"Query" name:"EndUserId"  type:"Repeated"`
}

// DeleteCloudDriveUsersResponse is the response struct for api DeleteCloudDriveUsers
type DeleteCloudDriveUsersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteCloudDriveUsersRequest creates a request to invoke DeleteCloudDriveUsers API
func CreateDeleteCloudDriveUsersRequest() (request *DeleteCloudDriveUsersRequest) {
	request = &DeleteCloudDriveUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DeleteCloudDriveUsers", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteCloudDriveUsersResponse creates a response to parse from DeleteCloudDriveUsers response
func CreateDeleteCloudDriveUsersResponse() (response *DeleteCloudDriveUsersResponse) {
	response = &DeleteCloudDriveUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
