package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDiskReplicaGroup invokes the ebs.CreateDiskReplicaGroup API synchronously
func (client *Client) CreateDiskReplicaGroup(request *CreateDiskReplicaGroupRequest) (response *CreateDiskReplicaGroupResponse, err error) {
	response = CreateCreateDiskReplicaGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDiskReplicaGroupWithChan invokes the ebs.CreateDiskReplicaGroup API asynchronously
func (client *Client) CreateDiskReplicaGroupWithChan(request *CreateDiskReplicaGroupRequest) (<-chan *CreateDiskReplicaGroupResponse, <-chan error) {
	responseChan := make(chan *CreateDiskReplicaGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDiskReplicaGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDiskReplicaGroupWithCallback invokes the ebs.CreateDiskReplicaGroup API asynchronously
func (client *Client) CreateDiskReplicaGroupWithCallback(request *CreateDiskReplicaGroupRequest, callback func(response *CreateDiskReplicaGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDiskReplicaGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateDiskReplicaGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDiskReplicaGroupRequest is the request struct for api CreateDiskReplicaGroup
type CreateDiskReplicaGroupRequest struct {
	*requests.RpcRequest
	ClientToken         string                       `position:"Query" name:"ClientToken"`
	DestinationRegionId string                       `position:"Query" name:"DestinationRegionId"`
	Description         string                       `position:"Query" name:"Description"`
	SourceZoneId        string                       `position:"Query" name:"SourceZoneId"`
	DestinationZoneId   string                       `position:"Query" name:"DestinationZoneId"`
	ResourceGroupId     string                       `position:"Query" name:"ResourceGroupId"`
	Tag                 *[]CreateDiskReplicaGroupTag `position:"Query" name:"Tag"  type:"Repeated"`
	DestinationCloudId  string                       `position:"Query" name:"DestinationCloudId"`
	Bandwidth           requests.Integer             `position:"Query" name:"Bandwidth"`
	DestinationUid      string                       `position:"Query" name:"DestinationUid"`
	GroupName           string                       `position:"Query" name:"GroupName"`
	RPO                 requests.Integer             `position:"Query" name:"RPO"`
}

// CreateDiskReplicaGroupTag is a repeated param struct in CreateDiskReplicaGroupRequest
type CreateDiskReplicaGroupTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateDiskReplicaGroupResponse is the response struct for api CreateDiskReplicaGroup
type CreateDiskReplicaGroupResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ReplicaGroupId string `json:"ReplicaGroupId" xml:"ReplicaGroupId"`
}

// CreateCreateDiskReplicaGroupRequest creates a request to invoke CreateDiskReplicaGroup API
func CreateCreateDiskReplicaGroupRequest() (request *CreateDiskReplicaGroupRequest) {
	request = &CreateDiskReplicaGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "CreateDiskReplicaGroup", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDiskReplicaGroupResponse creates a response to parse from CreateDiskReplicaGroup response
func CreateCreateDiskReplicaGroupResponse() (response *CreateDiskReplicaGroupResponse) {
	response = &CreateDiskReplicaGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
