package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelLensService invokes the ebs.CancelLensService API synchronously
func (client *Client) CancelLensService(request *CancelLensServiceRequest) (response *CancelLensServiceResponse, err error) {
	response = CreateCancelLensServiceResponse()
	err = client.DoAction(request, response)
	return
}

// CancelLensServiceWithChan invokes the ebs.CancelLensService API asynchronously
func (client *Client) CancelLensServiceWithChan(request *CancelLensServiceRequest) (<-chan *CancelLensServiceResponse, <-chan error) {
	responseChan := make(chan *CancelLensServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelLensService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelLensServiceWithCallback invokes the ebs.CancelLensService API asynchronously
func (client *Client) CancelLensServiceWithCallback(request *CancelLensServiceRequest, callback func(response *CancelLensServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelLensServiceResponse
		var err error
		defer close(result)
		response, err = client.CancelLensService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelLensServiceRequest is the request struct for api CancelLensService
type CancelLensServiceRequest struct {
	*requests.RpcRequest
}

// CancelLensServiceResponse is the response struct for api CancelLensService
type CancelLensServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCancelLensServiceRequest creates a request to invoke CancelLensService API
func CreateCancelLensServiceRequest() (request *CancelLensServiceRequest) {
	request = &CancelLensServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "CancelLensService", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelLensServiceResponse creates a response to parse from CancelLensService response
func CreateCancelLensServiceResponse() (response *CancelLensServiceResponse) {
	response = &CancelLensServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
