package dytnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PhoneNumberStatusForSms invokes the dytnsapi.PhoneNumberStatusForSms API synchronously
func (client *Client) PhoneNumberStatusForSms(request *PhoneNumberStatusForSmsRequest) (response *PhoneNumberStatusForSmsResponse, err error) {
	response = CreatePhoneNumberStatusForSmsResponse()
	err = client.DoAction(request, response)
	return
}

// PhoneNumberStatusForSmsWithChan invokes the dytnsapi.PhoneNumberStatusForSms API asynchronously
func (client *Client) PhoneNumberStatusForSmsWithChan(request *PhoneNumberStatusForSmsRequest) (<-chan *PhoneNumberStatusForSmsResponse, <-chan error) {
	responseChan := make(chan *PhoneNumberStatusForSmsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PhoneNumberStatusForSms(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PhoneNumberStatusForSmsWithCallback invokes the dytnsapi.PhoneNumberStatusForSms API asynchronously
func (client *Client) PhoneNumberStatusForSmsWithCallback(request *PhoneNumberStatusForSmsRequest, callback func(response *PhoneNumberStatusForSmsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PhoneNumberStatusForSmsResponse
		var err error
		defer close(result)
		response, err = client.PhoneNumberStatusForSms(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PhoneNumberStatusForSmsRequest is the request struct for api PhoneNumberStatusForSms
type PhoneNumberStatusForSmsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ExtendFunction       string           `position:"Query" name:"ExtendFunction"`
	RouteName            string           `position:"Query" name:"RouteName"`
	Mask                 string           `position:"Query" name:"Mask"`
	ResultCount          string           `position:"Query" name:"ResultCount"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	AuthCode             string           `position:"Query" name:"AuthCode"`
	InputNumber          string           `position:"Query" name:"InputNumber"`
	FlowName             string           `position:"Query" name:"FlowName"`
	PhoneStatusSceneCode string           `position:"Query" name:"PhoneStatusSceneCode"`
}

// PhoneNumberStatusForSmsResponse is the response struct for api PhoneNumberStatusForSms
type PhoneNumberStatusForSmsResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreatePhoneNumberStatusForSmsRequest creates a request to invoke PhoneNumberStatusForSms API
func CreatePhoneNumberStatusForSmsRequest() (request *PhoneNumberStatusForSmsRequest) {
	request = &PhoneNumberStatusForSmsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dytnsapi", "2020-02-17", "PhoneNumberStatusForSms", "", "")
	request.Method = requests.POST
	return
}

// CreatePhoneNumberStatusForSmsResponse creates a response to parse from PhoneNumberStatusForSms response
func CreatePhoneNumberStatusForSmsResponse() (response *PhoneNumberStatusForSmsResponse) {
	response = &PhoneNumberStatusForSmsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
