package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetBackupLocal invokes the drds.SetBackupLocal API synchronously
func (client *Client) SetBackupLocal(request *SetBackupLocalRequest) (response *SetBackupLocalResponse, err error) {
	response = CreateSetBackupLocalResponse()
	err = client.DoAction(request, response)
	return
}

// SetBackupLocalWithChan invokes the drds.SetBackupLocal API asynchronously
func (client *Client) SetBackupLocalWithChan(request *SetBackupLocalRequest) (<-chan *SetBackupLocalResponse, <-chan error) {
	responseChan := make(chan *SetBackupLocalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetBackupLocal(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetBackupLocalWithCallback invokes the drds.SetBackupLocal API asynchronously
func (client *Client) SetBackupLocalWithCallback(request *SetBackupLocalRequest, callback func(response *SetBackupLocalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetBackupLocalResponse
		var err error
		defer close(result)
		response, err = client.SetBackupLocal(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetBackupLocalRequest is the request struct for api SetBackupLocal
type SetBackupLocalRequest struct {
	*requests.RpcRequest
	LocalLogRetentionHours   string `position:"Query" name:"LocalLogRetentionHours"`
	LocalLogRetentionSpace   string `position:"Query" name:"LocalLogRetentionSpace"`
	DrdsInstanceId           string `position:"Query" name:"DrdsInstanceId"`
	HighSpaceUsageProtection string `position:"Query" name:"HighSpaceUsageProtection"`
}

// SetBackupLocalResponse is the response struct for api SetBackupLocal
type SetBackupLocalResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSetBackupLocalRequest creates a request to invoke SetBackupLocal API
func CreateSetBackupLocalRequest() (request *SetBackupLocalRequest) {
	request = &SetBackupLocalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "SetBackupLocal", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetBackupLocalResponse creates a response to parse from SetBackupLocal response
func CreateSetBackupLocalResponse() (response *SetBackupLocalResponse) {
	response = &SetBackupLocalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
