package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitOperationAuditInfo invokes the domain.SubmitOperationAuditInfo API synchronously
func (client *Client) SubmitOperationAuditInfo(request *SubmitOperationAuditInfoRequest) (response *SubmitOperationAuditInfoResponse, err error) {
	response = CreateSubmitOperationAuditInfoResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitOperationAuditInfoWithChan invokes the domain.SubmitOperationAuditInfo API asynchronously
func (client *Client) SubmitOperationAuditInfoWithChan(request *SubmitOperationAuditInfoRequest) (<-chan *SubmitOperationAuditInfoResponse, <-chan error) {
	responseChan := make(chan *SubmitOperationAuditInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitOperationAuditInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitOperationAuditInfoWithCallback invokes the domain.SubmitOperationAuditInfo API asynchronously
func (client *Client) SubmitOperationAuditInfoWithCallback(request *SubmitOperationAuditInfoRequest, callback func(response *SubmitOperationAuditInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitOperationAuditInfoResponse
		var err error
		defer close(result)
		response, err = client.SubmitOperationAuditInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitOperationAuditInfoRequest is the request struct for api SubmitOperationAuditInfo
type SubmitOperationAuditInfoRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	AuditInfo  string           `position:"Query" name:"AuditInfo"`
	AuditType  requests.Integer `position:"Query" name:"AuditType"`
	Id         requests.Integer `position:"Query" name:"Id"`
	Lang       string           `position:"Query" name:"Lang"`
}

// SubmitOperationAuditInfoResponse is the response struct for api SubmitOperationAuditInfo
type SubmitOperationAuditInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        int64  `json:"Id" xml:"Id"`
}

// CreateSubmitOperationAuditInfoRequest creates a request to invoke SubmitOperationAuditInfo API
func CreateSubmitOperationAuditInfoRequest() (request *SubmitOperationAuditInfoRequest) {
	request = &SubmitOperationAuditInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "SubmitOperationAuditInfo", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitOperationAuditInfoResponse creates a response to parse from SubmitOperationAuditInfo response
func CreateSubmitOperationAuditInfoResponse() (response *SubmitOperationAuditInfoResponse) {
	response = &SubmitOperationAuditInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
