package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTaskFlowNotification invokes the dms_enterprise.UpdateTaskFlowNotification API synchronously
func (client *Client) UpdateTaskFlowNotification(request *UpdateTaskFlowNotificationRequest) (response *UpdateTaskFlowNotificationResponse, err error) {
	response = CreateUpdateTaskFlowNotificationResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTaskFlowNotificationWithChan invokes the dms_enterprise.UpdateTaskFlowNotification API asynchronously
func (client *Client) UpdateTaskFlowNotificationWithChan(request *UpdateTaskFlowNotificationRequest) (<-chan *UpdateTaskFlowNotificationResponse, <-chan error) {
	responseChan := make(chan *UpdateTaskFlowNotificationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTaskFlowNotification(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTaskFlowNotificationWithCallback invokes the dms_enterprise.UpdateTaskFlowNotification API asynchronously
func (client *Client) UpdateTaskFlowNotificationWithCallback(request *UpdateTaskFlowNotificationRequest, callback func(response *UpdateTaskFlowNotificationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTaskFlowNotificationResponse
		var err error
		defer close(result)
		response, err = client.UpdateTaskFlowNotification(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTaskFlowNotificationRequest is the request struct for api UpdateTaskFlowNotification
type UpdateTaskFlowNotificationRequest struct {
	*requests.RpcRequest
	DagId                  requests.Integer `position:"Query" name:"DagId"`
	Tid                    requests.Integer `position:"Query" name:"Tid"`
	DagNotificationFail    requests.Boolean `position:"Query" name:"DagNotificationFail"`
	DagNotificationSla     requests.Boolean `position:"Query" name:"DagNotificationSla"`
	DagNotificationSuccess requests.Boolean `position:"Query" name:"DagNotificationSuccess"`
}

// UpdateTaskFlowNotificationResponse is the response struct for api UpdateTaskFlowNotification
type UpdateTaskFlowNotificationResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateUpdateTaskFlowNotificationRequest creates a request to invoke UpdateTaskFlowNotification API
func CreateUpdateTaskFlowNotificationRequest() (request *UpdateTaskFlowNotificationRequest) {
	request = &UpdateTaskFlowNotificationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "UpdateTaskFlowNotification", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTaskFlowNotificationResponse creates a response to parse from UpdateTaskFlowNotification response
func CreateUpdateTaskFlowNotificationResponse() (response *UpdateTaskFlowNotificationResponse) {
	response = &UpdateTaskFlowNotificationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
