package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RetryDataCorrectPreCheck invokes the dms_enterprise.RetryDataCorrectPreCheck API synchronously
func (client *Client) RetryDataCorrectPreCheck(request *RetryDataCorrectPreCheckRequest) (response *RetryDataCorrectPreCheckResponse, err error) {
	response = CreateRetryDataCorrectPreCheckResponse()
	err = client.DoAction(request, response)
	return
}

// RetryDataCorrectPreCheckWithChan invokes the dms_enterprise.RetryDataCorrectPreCheck API asynchronously
func (client *Client) RetryDataCorrectPreCheckWithChan(request *RetryDataCorrectPreCheckRequest) (<-chan *RetryDataCorrectPreCheckResponse, <-chan error) {
	responseChan := make(chan *RetryDataCorrectPreCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RetryDataCorrectPreCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RetryDataCorrectPreCheckWithCallback invokes the dms_enterprise.RetryDataCorrectPreCheck API asynchronously
func (client *Client) RetryDataCorrectPreCheckWithCallback(request *RetryDataCorrectPreCheckRequest, callback func(response *RetryDataCorrectPreCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RetryDataCorrectPreCheckResponse
		var err error
		defer close(result)
		response, err = client.RetryDataCorrectPreCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RetryDataCorrectPreCheckRequest is the request struct for api RetryDataCorrectPreCheck
type RetryDataCorrectPreCheckRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	OrderId requests.Integer `position:"Query" name:"OrderId"`
}

// RetryDataCorrectPreCheckResponse is the response struct for api RetryDataCorrectPreCheck
type RetryDataCorrectPreCheckResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateRetryDataCorrectPreCheckRequest creates a request to invoke RetryDataCorrectPreCheck API
func CreateRetryDataCorrectPreCheckRequest() (request *RetryDataCorrectPreCheckRequest) {
	request = &RetryDataCorrectPreCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "RetryDataCorrectPreCheck", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRetryDataCorrectPreCheckResponse creates a response to parse from RetryDataCorrectPreCheck response
func CreateRetryDataCorrectPreCheckResponse() (response *RetryDataCorrectPreCheckResponse) {
	response = &RetryDataCorrectPreCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
