package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataLakeTable invokes the dms_enterprise.GetDataLakeTable API synchronously
func (client *Client) GetDataLakeTable(request *GetDataLakeTableRequest) (response *GetDataLakeTableResponse, err error) {
	response = CreateGetDataLakeTableResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataLakeTableWithChan invokes the dms_enterprise.GetDataLakeTable API asynchronously
func (client *Client) GetDataLakeTableWithChan(request *GetDataLakeTableRequest) (<-chan *GetDataLakeTableResponse, <-chan error) {
	responseChan := make(chan *GetDataLakeTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataLakeTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataLakeTableWithCallback invokes the dms_enterprise.GetDataLakeTable API asynchronously
func (client *Client) GetDataLakeTableWithCallback(request *GetDataLakeTableRequest, callback func(response *GetDataLakeTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataLakeTableResponse
		var err error
		defer close(result)
		response, err = client.GetDataLakeTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataLakeTableRequest is the request struct for api GetDataLakeTable
type GetDataLakeTableRequest struct {
	*requests.RpcRequest
	Tid         requests.Integer `position:"Query" name:"Tid"`
	CatalogName string           `position:"Query" name:"CatalogName"`
	DbName      string           `position:"Query" name:"DbName"`
	DataRegion  string           `position:"Query" name:"DataRegion"`
	Name        string           `position:"Query" name:"Name"`
}

// GetDataLakeTableResponse is the response struct for api GetDataLakeTable
type GetDataLakeTableResponse struct {
	*responses.BaseResponse
}

// CreateGetDataLakeTableRequest creates a request to invoke GetDataLakeTable API
func CreateGetDataLakeTableRequest() (request *GetDataLakeTableRequest) {
	request = &GetDataLakeTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetDataLakeTable", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDataLakeTableResponse creates a response to parse from GetDataLakeTable response
func CreateGetDataLakeTableResponse() (response *GetDataLakeTableResponse) {
	response = &GetDataLakeTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
