package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyWebCacheCustomRule invokes the ddoscoo.ModifyWebCacheCustomRule API synchronously
func (client *Client) ModifyWebCacheCustomRule(request *ModifyWebCacheCustomRuleRequest) (response *ModifyWebCacheCustomRuleResponse, err error) {
	response = CreateModifyWebCacheCustomRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyWebCacheCustomRuleWithChan invokes the ddoscoo.ModifyWebCacheCustomRule API asynchronously
func (client *Client) ModifyWebCacheCustomRuleWithChan(request *ModifyWebCacheCustomRuleRequest) (<-chan *ModifyWebCacheCustomRuleResponse, <-chan error) {
	responseChan := make(chan *ModifyWebCacheCustomRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyWebCacheCustomRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyWebCacheCustomRuleWithCallback invokes the ddoscoo.ModifyWebCacheCustomRule API asynchronously
func (client *Client) ModifyWebCacheCustomRuleWithCallback(request *ModifyWebCacheCustomRuleRequest, callback func(response *ModifyWebCacheCustomRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyWebCacheCustomRuleResponse
		var err error
		defer close(result)
		response, err = client.ModifyWebCacheCustomRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyWebCacheCustomRuleRequest is the request struct for api ModifyWebCacheCustomRule
type ModifyWebCacheCustomRuleRequest struct {
	*requests.RpcRequest
	Rules           string `position:"Query" name:"Rules"`
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
}

// ModifyWebCacheCustomRuleResponse is the response struct for api ModifyWebCacheCustomRule
type ModifyWebCacheCustomRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyWebCacheCustomRuleRequest creates a request to invoke ModifyWebCacheCustomRule API
func CreateModifyWebCacheCustomRuleRequest() (request *ModifyWebCacheCustomRuleRequest) {
	request = &ModifyWebCacheCustomRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyWebCacheCustomRule", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyWebCacheCustomRuleResponse creates a response to parse from ModifyWebCacheCustomRule response
func CreateModifyWebCacheCustomRuleResponse() (response *ModifyWebCacheCustomRuleResponse) {
	response = &ModifyWebCacheCustomRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
