package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnSMCertificateDetail invokes the dcdn.DescribeDcdnSMCertificateDetail API synchronously
func (client *Client) DescribeDcdnSMCertificateDetail(request *DescribeDcdnSMCertificateDetailRequest) (response *DescribeDcdnSMCertificateDetailResponse, err error) {
	response = CreateDescribeDcdnSMCertificateDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnSMCertificateDetailWithChan invokes the dcdn.DescribeDcdnSMCertificateDetail API asynchronously
func (client *Client) DescribeDcdnSMCertificateDetailWithChan(request *DescribeDcdnSMCertificateDetailRequest) (<-chan *DescribeDcdnSMCertificateDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnSMCertificateDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnSMCertificateDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnSMCertificateDetailWithCallback invokes the dcdn.DescribeDcdnSMCertificateDetail API asynchronously
func (client *Client) DescribeDcdnSMCertificateDetailWithCallback(request *DescribeDcdnSMCertificateDetailRequest, callback func(response *DescribeDcdnSMCertificateDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnSMCertificateDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnSMCertificateDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnSMCertificateDetailRequest is the request struct for api DescribeDcdnSMCertificateDetail
type DescribeDcdnSMCertificateDetailRequest struct {
	*requests.RpcRequest
	SecurityToken  string           `position:"Query" name:"SecurityToken"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	CertIdentifier string           `position:"Query" name:"CertIdentifier"`
}

// DescribeDcdnSMCertificateDetailResponse is the response struct for api DescribeDcdnSMCertificateDetail
type DescribeDcdnSMCertificateDetailResponse struct {
	*responses.BaseResponse
	CertExpireTime     string `json:"CertExpireTime" xml:"CertExpireTime"`
	CertIdentifier     string `json:"CertIdentifier" xml:"CertIdentifier"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
	CommonName         string `json:"CommonName" xml:"CommonName"`
	CertName           string `json:"CertName" xml:"CertName"`
	Sans               string `json:"Sans" xml:"Sans"`
	SignCertificate    string `json:"SignCertificate" xml:"SignCertificate"`
	CertOrg            string `json:"CertOrg" xml:"CertOrg"`
	EncryptCertificate string `json:"EncryptCertificate" xml:"EncryptCertificate"`
}

// CreateDescribeDcdnSMCertificateDetailRequest creates a request to invoke DescribeDcdnSMCertificateDetail API
func CreateDescribeDcdnSMCertificateDetailRequest() (request *DescribeDcdnSMCertificateDetailRequest) {
	request = &DescribeDcdnSMCertificateDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnSMCertificateDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnSMCertificateDetailResponse creates a response to parse from DescribeDcdnSMCertificateDetail response
func CreateDescribeDcdnSMCertificateDetailResponse() (response *DescribeDcdnSMCertificateDetailResponse) {
	response = &DescribeDcdnSMCertificateDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
