package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnSLSRealTimeLogType invokes the dcdn.DescribeDcdnSLSRealTimeLogType API synchronously
func (client *Client) DescribeDcdnSLSRealTimeLogType(request *DescribeDcdnSLSRealTimeLogTypeRequest) (response *DescribeDcdnSLSRealTimeLogTypeResponse, err error) {
	response = CreateDescribeDcdnSLSRealTimeLogTypeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnSLSRealTimeLogTypeWithChan invokes the dcdn.DescribeDcdnSLSRealTimeLogType API asynchronously
func (client *Client) DescribeDcdnSLSRealTimeLogTypeWithChan(request *DescribeDcdnSLSRealTimeLogTypeRequest) (<-chan *DescribeDcdnSLSRealTimeLogTypeResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnSLSRealTimeLogTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnSLSRealTimeLogType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnSLSRealTimeLogTypeWithCallback invokes the dcdn.DescribeDcdnSLSRealTimeLogType API asynchronously
func (client *Client) DescribeDcdnSLSRealTimeLogTypeWithCallback(request *DescribeDcdnSLSRealTimeLogTypeRequest, callback func(response *DescribeDcdnSLSRealTimeLogTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnSLSRealTimeLogTypeResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnSLSRealTimeLogType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnSLSRealTimeLogTypeRequest is the request struct for api DescribeDcdnSLSRealTimeLogType
type DescribeDcdnSLSRealTimeLogTypeRequest struct {
	*requests.RpcRequest
}

// DescribeDcdnSLSRealTimeLogTypeResponse is the response struct for api DescribeDcdnSLSRealTimeLogType
type DescribeDcdnSLSRealTimeLogTypeResponse struct {
	*responses.BaseResponse
	RequestId string                                  `json:"RequestId" xml:"RequestId"`
	Content   ContentInDescribeDcdnSLSRealTimeLogType `json:"Content" xml:"Content"`
}

// CreateDescribeDcdnSLSRealTimeLogTypeRequest creates a request to invoke DescribeDcdnSLSRealTimeLogType API
func CreateDescribeDcdnSLSRealTimeLogTypeRequest() (request *DescribeDcdnSLSRealTimeLogTypeRequest) {
	request = &DescribeDcdnSLSRealTimeLogTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnSLSRealTimeLogType", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeDcdnSLSRealTimeLogTypeResponse creates a response to parse from DescribeDcdnSLSRealTimeLogType response
func CreateDescribeDcdnSLSRealTimeLogTypeResponse() (response *DescribeDcdnSLSRealTimeLogTypeResponse) {
	response = &DescribeDcdnSLSRealTimeLogTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
