package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainRealTimeTrafficData invokes the dcdn.DescribeDcdnDomainRealTimeTrafficData API synchronously
func (client *Client) DescribeDcdnDomainRealTimeTrafficData(request *DescribeDcdnDomainRealTimeTrafficDataRequest) (response *DescribeDcdnDomainRealTimeTrafficDataResponse, err error) {
	response = CreateDescribeDcdnDomainRealTimeTrafficDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainRealTimeTrafficDataWithChan invokes the dcdn.DescribeDcdnDomainRealTimeTrafficData API asynchronously
func (client *Client) DescribeDcdnDomainRealTimeTrafficDataWithChan(request *DescribeDcdnDomainRealTimeTrafficDataRequest) (<-chan *DescribeDcdnDomainRealTimeTrafficDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainRealTimeTrafficDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainRealTimeTrafficData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainRealTimeTrafficDataWithCallback invokes the dcdn.DescribeDcdnDomainRealTimeTrafficData API asynchronously
func (client *Client) DescribeDcdnDomainRealTimeTrafficDataWithCallback(request *DescribeDcdnDomainRealTimeTrafficDataRequest, callback func(response *DescribeDcdnDomainRealTimeTrafficDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainRealTimeTrafficDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainRealTimeTrafficData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainRealTimeTrafficDataRequest is the request struct for api DescribeDcdnDomainRealTimeTrafficData
type DescribeDcdnDomainRealTimeTrafficDataRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
	EndTime    string `position:"Query" name:"EndTime"`
	StartTime  string `position:"Query" name:"StartTime"`
}

// DescribeDcdnDomainRealTimeTrafficDataResponse is the response struct for api DescribeDcdnDomainRealTimeTrafficData
type DescribeDcdnDomainRealTimeTrafficDataResponse struct {
	*responses.BaseResponse
	EndTime                        string                         `json:"EndTime" xml:"EndTime"`
	StartTime                      string                         `json:"StartTime" xml:"StartTime"`
	RequestId                      string                         `json:"RequestId" xml:"RequestId"`
	DomainName                     string                         `json:"DomainName" xml:"DomainName"`
	DataInterval                   string                         `json:"DataInterval" xml:"DataInterval"`
	RealTimeTrafficDataPerInterval RealTimeTrafficDataPerInterval `json:"RealTimeTrafficDataPerInterval" xml:"RealTimeTrafficDataPerInterval"`
}

// CreateDescribeDcdnDomainRealTimeTrafficDataRequest creates a request to invoke DescribeDcdnDomainRealTimeTrafficData API
func CreateDescribeDcdnDomainRealTimeTrafficDataRequest() (request *DescribeDcdnDomainRealTimeTrafficDataRequest) {
	request = &DescribeDcdnDomainRealTimeTrafficDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainRealTimeTrafficData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDomainRealTimeTrafficDataResponse creates a response to parse from DescribeDcdnDomainRealTimeTrafficData response
func CreateDescribeDcdnDomainRealTimeTrafficDataResponse() (response *DescribeDcdnDomainRealTimeTrafficDataResponse) {
	response = &DescribeDcdnDomainRealTimeTrafficDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
