package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainHttpCodeDataByLayer invokes the dcdn.DescribeDcdnDomainHttpCodeDataByLayer API synchronously
func (client *Client) DescribeDcdnDomainHttpCodeDataByLayer(request *DescribeDcdnDomainHttpCodeDataByLayerRequest) (response *DescribeDcdnDomainHttpCodeDataByLayerResponse, err error) {
	response = CreateDescribeDcdnDomainHttpCodeDataByLayerResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainHttpCodeDataByLayerWithChan invokes the dcdn.DescribeDcdnDomainHttpCodeDataByLayer API asynchronously
func (client *Client) DescribeDcdnDomainHttpCodeDataByLayerWithChan(request *DescribeDcdnDomainHttpCodeDataByLayerRequest) (<-chan *DescribeDcdnDomainHttpCodeDataByLayerResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainHttpCodeDataByLayerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainHttpCodeDataByLayer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainHttpCodeDataByLayerWithCallback invokes the dcdn.DescribeDcdnDomainHttpCodeDataByLayer API asynchronously
func (client *Client) DescribeDcdnDomainHttpCodeDataByLayerWithCallback(request *DescribeDcdnDomainHttpCodeDataByLayerRequest, callback func(response *DescribeDcdnDomainHttpCodeDataByLayerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainHttpCodeDataByLayerResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainHttpCodeDataByLayer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainHttpCodeDataByLayerRequest is the request struct for api DescribeDcdnDomainHttpCodeDataByLayer
type DescribeDcdnDomainHttpCodeDataByLayerRequest struct {
	*requests.RpcRequest
	DomainName     string `position:"Query" name:"DomainName"`
	EndTime        string `position:"Query" name:"EndTime"`
	Interval       string `position:"Query" name:"Interval"`
	LocationNameEn string `position:"Query" name:"LocationNameEn"`
	StartTime      string `position:"Query" name:"StartTime"`
	IspNameEn      string `position:"Query" name:"IspNameEn"`
	Layer          string `position:"Query" name:"Layer"`
}

// DescribeDcdnDomainHttpCodeDataByLayerResponse is the response struct for api DescribeDcdnDomainHttpCodeDataByLayer
type DescribeDcdnDomainHttpCodeDataByLayerResponse struct {
	*responses.BaseResponse
	DataInterval         string               `json:"DataInterval" xml:"DataInterval"`
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	HttpCodeDataInterval HttpCodeDataInterval `json:"HttpCodeDataInterval" xml:"HttpCodeDataInterval"`
}

// CreateDescribeDcdnDomainHttpCodeDataByLayerRequest creates a request to invoke DescribeDcdnDomainHttpCodeDataByLayer API
func CreateDescribeDcdnDomainHttpCodeDataByLayerRequest() (request *DescribeDcdnDomainHttpCodeDataByLayerRequest) {
	request = &DescribeDcdnDomainHttpCodeDataByLayerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainHttpCodeDataByLayer", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDomainHttpCodeDataByLayerResponse creates a response to parse from DescribeDcdnDomainHttpCodeDataByLayer response
func CreateDescribeDcdnDomainHttpCodeDataByLayerResponse() (response *DescribeDcdnDomainHttpCodeDataByLayerResponse) {
	response = &DescribeDcdnDomainHttpCodeDataByLayerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
