package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateFolder invokes the dataworks_public.UpdateFolder API synchronously
func (client *Client) UpdateFolder(request *UpdateFolderRequest) (response *UpdateFolderResponse, err error) {
	response = CreateUpdateFolderResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateFolderWithChan invokes the dataworks_public.UpdateFolder API asynchronously
func (client *Client) UpdateFolderWithChan(request *UpdateFolderRequest) (<-chan *UpdateFolderResponse, <-chan error) {
	responseChan := make(chan *UpdateFolderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateFolder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateFolderWithCallback invokes the dataworks_public.UpdateFolder API asynchronously
func (client *Client) UpdateFolderWithCallback(request *UpdateFolderRequest, callback func(response *UpdateFolderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateFolderResponse
		var err error
		defer close(result)
		response, err = client.UpdateFolder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateFolderRequest is the request struct for api UpdateFolder
type UpdateFolderRequest struct {
	*requests.RpcRequest
	FolderName        string           `position:"Body" name:"FolderName"`
	ProjectId         requests.Integer `position:"Body" name:"ProjectId"`
	ProjectIdentifier string           `position:"Body" name:"ProjectIdentifier"`
	FolderId          string           `position:"Body" name:"FolderId"`
}

// UpdateFolderResponse is the response struct for api UpdateFolder
type UpdateFolderResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateUpdateFolderRequest creates a request to invoke UpdateFolder API
func CreateUpdateFolderRequest() (request *UpdateFolderRequest) {
	request = &UpdateFolderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "UpdateFolder", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateFolderResponse creates a response to parse from UpdateFolder response
func CreateUpdateFolderResponse() (response *UpdateFolderResponse) {
	response = &UpdateFolderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
