package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListConnections invokes the dataworks_public.ListConnections API synchronously
func (client *Client) ListConnections(request *ListConnectionsRequest) (response *ListConnectionsResponse, err error) {
	response = CreateListConnectionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListConnectionsWithChan invokes the dataworks_public.ListConnections API asynchronously
func (client *Client) ListConnectionsWithChan(request *ListConnectionsRequest) (<-chan *ListConnectionsResponse, <-chan error) {
	responseChan := make(chan *ListConnectionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListConnections(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListConnectionsWithCallback invokes the dataworks_public.ListConnections API asynchronously
func (client *Client) ListConnectionsWithCallback(request *ListConnectionsRequest, callback func(response *ListConnectionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListConnectionsResponse
		var err error
		defer close(result)
		response, err = client.ListConnections(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListConnectionsRequest is the request struct for api ListConnections
type ListConnectionsRequest struct {
	*requests.RpcRequest
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	SubType        string           `position:"Query" name:"SubType"`
	Name           string           `position:"Query" name:"Name"`
	EnvType        requests.Integer `position:"Query" name:"EnvType"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	ConnectionType string           `position:"Query" name:"ConnectionType"`
	ProjectId      requests.Integer `position:"Query" name:"ProjectId"`
	Status         string           `position:"Query" name:"Status"`
}

// ListConnectionsResponse is the response struct for api ListConnections
type ListConnectionsResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateListConnectionsRequest creates a request to invoke ListConnections API
func CreateListConnectionsRequest() (request *ListConnectionsRequest) {
	request = &ListConnectionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListConnections", "", "")
	request.Method = requests.GET
	return
}

// CreateListConnectionsResponse creates a response to parse from ListConnections response
func CreateListConnectionsResponse() (response *ListConnectionsResponse) {
	response = &ListConnectionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
