package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMetaTableFullInfo invokes the dataworks_public.GetMetaTableFullInfo API synchronously
func (client *Client) GetMetaTableFullInfo(request *GetMetaTableFullInfoRequest) (response *GetMetaTableFullInfoResponse, err error) {
	response = CreateGetMetaTableFullInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetMetaTableFullInfoWithChan invokes the dataworks_public.GetMetaTableFullInfo API asynchronously
func (client *Client) GetMetaTableFullInfoWithChan(request *GetMetaTableFullInfoRequest) (<-chan *GetMetaTableFullInfoResponse, <-chan error) {
	responseChan := make(chan *GetMetaTableFullInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMetaTableFullInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMetaTableFullInfoWithCallback invokes the dataworks_public.GetMetaTableFullInfo API asynchronously
func (client *Client) GetMetaTableFullInfoWithCallback(request *GetMetaTableFullInfoRequest, callback func(response *GetMetaTableFullInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMetaTableFullInfoResponse
		var err error
		defer close(result)
		response, err = client.GetMetaTableFullInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMetaTableFullInfoRequest is the request struct for api GetMetaTableFullInfo
type GetMetaTableFullInfoRequest struct {
	*requests.RpcRequest
	DataSourceType string           `position:"Query" name:"DataSourceType"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	PageNum        requests.Integer `position:"Query" name:"PageNum"`
	TableGuid      string           `position:"Query" name:"TableGuid"`
	DatabaseName   string           `position:"Query" name:"DatabaseName"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	TableName      string           `position:"Query" name:"TableName"`
}

// GetMetaTableFullInfoResponse is the response struct for api GetMetaTableFullInfo
type GetMetaTableFullInfoResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetMetaTableFullInfoRequest creates a request to invoke GetMetaTableFullInfo API
func CreateGetMetaTableFullInfoRequest() (request *GetMetaTableFullInfoRequest) {
	request = &GetMetaTableFullInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetMetaTableFullInfo", "", "")
	request.Method = requests.GET
	return
}

// CreateGetMetaTableFullInfoResponse creates a response to parse from GetMetaTableFullInfo response
func CreateGetMetaTableFullInfoResponse() (response *GetMetaTableFullInfoResponse) {
	response = &GetMetaTableFullInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
