package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgUserGroupAddOrUpdate invokes the dataworks_public.DsgUserGroupAddOrUpdate API synchronously
func (client *Client) DsgUserGroupAddOrUpdate(request *DsgUserGroupAddOrUpdateRequest) (response *DsgUserGroupAddOrUpdateResponse, err error) {
	response = CreateDsgUserGroupAddOrUpdateResponse()
	err = client.DoAction(request, response)
	return
}

// DsgUserGroupAddOrUpdateWithChan invokes the dataworks_public.DsgUserGroupAddOrUpdate API asynchronously
func (client *Client) DsgUserGroupAddOrUpdateWithChan(request *DsgUserGroupAddOrUpdateRequest) (<-chan *DsgUserGroupAddOrUpdateResponse, <-chan error) {
	responseChan := make(chan *DsgUserGroupAddOrUpdateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgUserGroupAddOrUpdate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgUserGroupAddOrUpdateWithCallback invokes the dataworks_public.DsgUserGroupAddOrUpdate API asynchronously
func (client *Client) DsgUserGroupAddOrUpdateWithCallback(request *DsgUserGroupAddOrUpdateRequest, callback func(response *DsgUserGroupAddOrUpdateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgUserGroupAddOrUpdateResponse
		var err error
		defer close(result)
		response, err = client.DsgUserGroupAddOrUpdate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgUserGroupAddOrUpdateRequest is the request struct for api DsgUserGroupAddOrUpdate
type DsgUserGroupAddOrUpdateRequest struct {
	*requests.RpcRequest
	UserGroups *[]DsgUserGroupAddOrUpdateUserGroups `position:"Query" name:"UserGroups"  type:"Json"`
}

// DsgUserGroupAddOrUpdateUserGroups is a repeated param struct in DsgUserGroupAddOrUpdateRequest
type DsgUserGroupAddOrUpdateUserGroups struct {
	Owner         string    `name:"Owner"`
	ProjectName   string    `name:"ProjectName"`
	UserGroupType string    `name:"UserGroupType"`
	Name          string    `name:"Name"`
	Id            string    `name:"Id"`
	Accounts      *[]string `name:"Accounts" type:"Repeated"`
}

// DsgUserGroupAddOrUpdateResponse is the response struct for api DsgUserGroupAddOrUpdate
type DsgUserGroupAddOrUpdateResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           bool   `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateDsgUserGroupAddOrUpdateRequest creates a request to invoke DsgUserGroupAddOrUpdate API
func CreateDsgUserGroupAddOrUpdateRequest() (request *DsgUserGroupAddOrUpdateRequest) {
	request = &DsgUserGroupAddOrUpdateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgUserGroupAddOrUpdate", "", "")
	request.Method = requests.POST
	return
}

// CreateDsgUserGroupAddOrUpdateResponse creates a response to parse from DsgUserGroupAddOrUpdate response
func CreateDsgUserGroupAddOrUpdateResponse() (response *DsgUserGroupAddOrUpdateResponse) {
	response = &DsgUserGroupAddOrUpdateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
