package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DesensitizeData invokes the dataworks_public.DesensitizeData API synchronously
func (client *Client) DesensitizeData(request *DesensitizeDataRequest) (response *DesensitizeDataResponse, err error) {
	response = CreateDesensitizeDataResponse()
	err = client.DoAction(request, response)
	return
}

// DesensitizeDataWithChan invokes the dataworks_public.DesensitizeData API asynchronously
func (client *Client) DesensitizeDataWithChan(request *DesensitizeDataRequest) (<-chan *DesensitizeDataResponse, <-chan error) {
	responseChan := make(chan *DesensitizeDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DesensitizeData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DesensitizeDataWithCallback invokes the dataworks_public.DesensitizeData API asynchronously
func (client *Client) DesensitizeDataWithCallback(request *DesensitizeDataRequest, callback func(response *DesensitizeDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DesensitizeDataResponse
		var err error
		defer close(result)
		response, err = client.DesensitizeData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DesensitizeDataRequest is the request struct for api DesensitizeData
type DesensitizeDataRequest struct {
	*requests.RpcRequest
	SceneCode string `position:"Body" name:"SceneCode"`
	Data      string `position:"Body" name:"Data"`
}

// DesensitizeDataResponse is the response struct for api DesensitizeData
type DesensitizeDataResponse struct {
	*responses.BaseResponse
	DesensitizeData string `json:"DesensitizeData" xml:"DesensitizeData"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
}

// CreateDesensitizeDataRequest creates a request to invoke DesensitizeData API
func CreateDesensitizeDataRequest() (request *DesensitizeDataRequest) {
	request = &DesensitizeDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DesensitizeData", "", "")
	request.Method = requests.GET
	return
}

// CreateDesensitizeDataResponse creates a response to parse from DesensitizeData response
func CreateDesensitizeDataResponse() (response *DesensitizeDataResponse) {
	response = &DesensitizeDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
