package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddRecognizeRule invokes the dataworks_public.AddRecognizeRule API synchronously
func (client *Client) AddRecognizeRule(request *AddRecognizeRuleRequest) (response *AddRecognizeRuleResponse, err error) {
	response = CreateAddRecognizeRuleResponse()
	err = client.DoAction(request, response)
	return
}

// AddRecognizeRuleWithChan invokes the dataworks_public.AddRecognizeRule API asynchronously
func (client *Client) AddRecognizeRuleWithChan(request *AddRecognizeRuleRequest) (<-chan *AddRecognizeRuleResponse, <-chan error) {
	responseChan := make(chan *AddRecognizeRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddRecognizeRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddRecognizeRuleWithCallback invokes the dataworks_public.AddRecognizeRule API asynchronously
func (client *Client) AddRecognizeRuleWithCallback(request *AddRecognizeRuleRequest, callback func(response *AddRecognizeRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddRecognizeRuleResponse
		var err error
		defer close(result)
		response, err = client.AddRecognizeRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddRecognizeRuleRequest is the request struct for api AddRecognizeRule
type AddRecognizeRuleRequest struct {
	*requests.RpcRequest
	Level                string           `position:"Body" name:"Level"`
	ColScan              string           `position:"Body" name:"ColScan"`
	ColExclude           string           `position:"Body" name:"ColExclude"`
	ContentScan          string           `position:"Body" name:"ContentScan"`
	OperationType        requests.Integer `position:"Body" name:"OperationType"`
	TemplateId           string           `position:"Body" name:"TemplateId"`
	RecognizeRulesType   string           `position:"Body" name:"RecognizeRulesType"`
	CommentScan          string           `position:"Body" name:"CommentScan"`
	AccountName          string           `position:"Body" name:"AccountName"`
	SensitiveDescription string           `position:"Body" name:"SensitiveDescription"`
	TenantId             string           `position:"Body" name:"TenantId"`
	RecognizeRules       string           `position:"Body" name:"RecognizeRules"`
	HitThreshold         requests.Integer `position:"Body" name:"HitThreshold"`
	SensitiveName        string           `position:"Body" name:"SensitiveName"`
	NodeParent           string           `position:"Body" name:"NodeParent"`
	LevelName            string           `position:"Body" name:"LevelName"`
	NodeId               string           `position:"Body" name:"NodeId"`
	Status               requests.Integer `position:"Body" name:"Status"`
}

// AddRecognizeRuleResponse is the response struct for api AddRecognizeRule
type AddRecognizeRuleResponse struct {
	*responses.BaseResponse
}

// CreateAddRecognizeRuleRequest creates a request to invoke AddRecognizeRule API
func CreateAddRecognizeRuleRequest() (request *AddRecognizeRuleRequest) {
	request = &AddRecognizeRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "AddRecognizeRule", "", "")
	request.Method = requests.POST
	return
}

// CreateAddRecognizeRuleResponse creates a response to parse from AddRecognizeRule response
func CreateAddRecognizeRuleResponse() (response *AddRecognizeRuleResponse) {
	response = &AddRecognizeRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
