package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQueryOptimizeSolution invokes the das.GetQueryOptimizeSolution API synchronously
func (client *Client) GetQueryOptimizeSolution(request *GetQueryOptimizeSolutionRequest) (response *GetQueryOptimizeSolutionResponse, err error) {
	response = CreateGetQueryOptimizeSolutionResponse()
	err = client.DoAction(request, response)
	return
}

// GetQueryOptimizeSolutionWithChan invokes the das.GetQueryOptimizeSolution API asynchronously
func (client *Client) GetQueryOptimizeSolutionWithChan(request *GetQueryOptimizeSolutionRequest) (<-chan *GetQueryOptimizeSolutionResponse, <-chan error) {
	responseChan := make(chan *GetQueryOptimizeSolutionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQueryOptimizeSolution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQueryOptimizeSolutionWithCallback invokes the das.GetQueryOptimizeSolution API asynchronously
func (client *Client) GetQueryOptimizeSolutionWithCallback(request *GetQueryOptimizeSolutionRequest, callback func(response *GetQueryOptimizeSolutionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQueryOptimizeSolutionResponse
		var err error
		defer close(result)
		response, err = client.GetQueryOptimizeSolution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQueryOptimizeSolutionRequest is the request struct for api GetQueryOptimizeSolution
type GetQueryOptimizeSolutionRequest struct {
	*requests.RpcRequest
	SqlId          string `position:"Query" name:"SqlId"`
	ConsoleContext string `position:"Query" name:"ConsoleContext"`
	RuleIds        string `position:"Query" name:"RuleIds"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	Engine         string `position:"Query" name:"Engine"`
}

// GetQueryOptimizeSolutionResponse is the response struct for api GetQueryOptimizeSolution
type GetQueryOptimizeSolutionResponse struct {
	*responses.BaseResponse
	Code      string                         `json:"Code" xml:"Code"`
	Message   string                         `json:"Message" xml:"Message"`
	RequestId string                         `json:"RequestId" xml:"RequestId"`
	Success   string                         `json:"Success" xml:"Success"`
	Data      DataInGetQueryOptimizeSolution `json:"Data" xml:"Data"`
}

// CreateGetQueryOptimizeSolutionRequest creates a request to invoke GetQueryOptimizeSolution API
func CreateGetQueryOptimizeSolutionRequest() (request *GetQueryOptimizeSolutionRequest) {
	request = &GetQueryOptimizeSolutionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetQueryOptimizeSolution", "", "")
	request.Method = requests.GET
	return
}

// CreateGetQueryOptimizeSolutionResponse creates a response to parse from GetQueryOptimizeSolution response
func CreateGetQueryOptimizeSolutionResponse() (response *GetQueryOptimizeSolutionResponse) {
	response = &GetQueryOptimizeSolutionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
