package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableInstanceDasConfig invokes the das.DisableInstanceDasConfig API synchronously
func (client *Client) DisableInstanceDasConfig(request *DisableInstanceDasConfigRequest) (response *DisableInstanceDasConfigResponse, err error) {
	response = CreateDisableInstanceDasConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DisableInstanceDasConfigWithChan invokes the das.DisableInstanceDasConfig API asynchronously
func (client *Client) DisableInstanceDasConfigWithChan(request *DisableInstanceDasConfigRequest) (<-chan *DisableInstanceDasConfigResponse, <-chan error) {
	responseChan := make(chan *DisableInstanceDasConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableInstanceDasConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableInstanceDasConfigWithCallback invokes the das.DisableInstanceDasConfig API asynchronously
func (client *Client) DisableInstanceDasConfigWithCallback(request *DisableInstanceDasConfigRequest, callback func(response *DisableInstanceDasConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableInstanceDasConfigResponse
		var err error
		defer close(result)
		response, err = client.DisableInstanceDasConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableInstanceDasConfigRequest is the request struct for api DisableInstanceDasConfig
type DisableInstanceDasConfigRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	Engine     string `position:"Query" name:"Engine"`
	ScaleType  string `position:"Query" name:"ScaleType"`
}

// DisableInstanceDasConfigResponse is the response struct for api DisableInstanceDasConfig
type DisableInstanceDasConfigResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateDisableInstanceDasConfigRequest creates a request to invoke DisableInstanceDasConfig API
func CreateDisableInstanceDasConfigRequest() (request *DisableInstanceDasConfigRequest) {
	request = &DisableInstanceDasConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "DisableInstanceDasConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateDisableInstanceDasConfigResponse creates a response to parse from DisableInstanceDasConfig response
func CreateDisableInstanceDasConfigResponse() (response *DisableInstanceDasConfigResponse) {
	response = &DisableInstanceDasConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
