package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateKillInstanceSessionTaskWithMaintainUser invokes the das.CreateKillInstanceSessionTaskWithMaintainUser API synchronously
func (client *Client) CreateKillInstanceSessionTaskWithMaintainUser(request *CreateKillInstanceSessionTaskWithMaintainUserRequest) (response *CreateKillInstanceSessionTaskWithMaintainUserResponse, err error) {
	response = CreateCreateKillInstanceSessionTaskWithMaintainUserResponse()
	err = client.DoAction(request, response)
	return
}

// CreateKillInstanceSessionTaskWithMaintainUserWithChan invokes the das.CreateKillInstanceSessionTaskWithMaintainUser API asynchronously
func (client *Client) CreateKillInstanceSessionTaskWithMaintainUserWithChan(request *CreateKillInstanceSessionTaskWithMaintainUserRequest) (<-chan *CreateKillInstanceSessionTaskWithMaintainUserResponse, <-chan error) {
	responseChan := make(chan *CreateKillInstanceSessionTaskWithMaintainUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateKillInstanceSessionTaskWithMaintainUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateKillInstanceSessionTaskWithMaintainUserWithCallback invokes the das.CreateKillInstanceSessionTaskWithMaintainUser API asynchronously
func (client *Client) CreateKillInstanceSessionTaskWithMaintainUserWithCallback(request *CreateKillInstanceSessionTaskWithMaintainUserRequest, callback func(response *CreateKillInstanceSessionTaskWithMaintainUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateKillInstanceSessionTaskWithMaintainUserResponse
		var err error
		defer close(result)
		response, err = client.CreateKillInstanceSessionTaskWithMaintainUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateKillInstanceSessionTaskWithMaintainUserRequest is the request struct for api CreateKillInstanceSessionTaskWithMaintainUser
type CreateKillInstanceSessionTaskWithMaintainUserRequest struct {
	*requests.RpcRequest
	KillAllSessions requests.Boolean `position:"Query" name:"KillAllSessions"`
	SessionIds      string           `position:"Query" name:"SessionIds"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	IgnoredUsers    string           `position:"Query" name:"IgnoredUsers"`
	NodeId          string           `position:"Query" name:"NodeId"`
}

// CreateKillInstanceSessionTaskWithMaintainUserResponse is the response struct for api CreateKillInstanceSessionTaskWithMaintainUser
type CreateKillInstanceSessionTaskWithMaintainUserResponse struct {
	*responses.BaseResponse
	Code      int64  `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCreateKillInstanceSessionTaskWithMaintainUserRequest creates a request to invoke CreateKillInstanceSessionTaskWithMaintainUser API
func CreateCreateKillInstanceSessionTaskWithMaintainUserRequest() (request *CreateKillInstanceSessionTaskWithMaintainUserRequest) {
	request = &CreateKillInstanceSessionTaskWithMaintainUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "CreateKillInstanceSessionTaskWithMaintainUser", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateKillInstanceSessionTaskWithMaintainUserResponse creates a response to parse from CreateKillInstanceSessionTaskWithMaintainUser response
func CreateCreateKillInstanceSessionTaskWithMaintainUserResponse() (response *CreateKillInstanceSessionTaskWithMaintainUserResponse) {
	response = &CreateKillInstanceSessionTaskWithMaintainUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
