package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDynamicRoute invokes the csas.UpdateDynamicRoute API synchronously
func (client *Client) UpdateDynamicRoute(request *UpdateDynamicRouteRequest) (response *UpdateDynamicRouteResponse, err error) {
	response = CreateUpdateDynamicRouteResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDynamicRouteWithChan invokes the csas.UpdateDynamicRoute API asynchronously
func (client *Client) UpdateDynamicRouteWithChan(request *UpdateDynamicRouteRequest) (<-chan *UpdateDynamicRouteResponse, <-chan error) {
	responseChan := make(chan *UpdateDynamicRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDynamicRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDynamicRouteWithCallback invokes the csas.UpdateDynamicRoute API asynchronously
func (client *Client) UpdateDynamicRouteWithCallback(request *UpdateDynamicRouteRequest, callback func(response *UpdateDynamicRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDynamicRouteResponse
		var err error
		defer close(result)
		response, err = client.UpdateDynamicRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDynamicRouteRequest is the request struct for api UpdateDynamicRoute
type UpdateDynamicRouteRequest struct {
	*requests.RpcRequest
	Description      string           `position:"Body" name:"Description"`
	DynamicRouteId   string           `position:"Body" name:"DynamicRouteId"`
	SourceIp         string           `position:"Query" name:"SourceIp"`
	DynamicRouteType string           `position:"Body" name:"DynamicRouteType"`
	TagIds           *[]string        `position:"Body" name:"TagIds"  type:"Repeated"`
	RegionIds        *[]string        `position:"Body" name:"RegionIds"  type:"Repeated"`
	Priority         requests.Integer `position:"Body" name:"Priority"`
	NextHop          string           `position:"Body" name:"NextHop"`
	ApplicationIds   *[]string        `position:"Body" name:"ApplicationIds"  type:"Repeated"`
	ModifyType       string           `position:"Body" name:"ModifyType"`
	Name             string           `position:"Body" name:"Name"`
	ApplicationType  string           `position:"Body" name:"ApplicationType"`
	Status           string           `position:"Body" name:"Status"`
}

// UpdateDynamicRouteResponse is the response struct for api UpdateDynamicRoute
type UpdateDynamicRouteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDynamicRouteRequest creates a request to invoke UpdateDynamicRoute API
func CreateUpdateDynamicRouteRequest() (request *UpdateDynamicRouteRequest) {
	request = &UpdateDynamicRouteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "UpdateDynamicRoute", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateDynamicRouteResponse creates a response to parse from UpdateDynamicRoute response
func CreateUpdateDynamicRouteResponse() (response *UpdateDynamicRouteResponse) {
	response = &UpdateDynamicRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
