package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserDevice invokes the csas.GetUserDevice API synchronously
func (client *Client) GetUserDevice(request *GetUserDeviceRequest) (response *GetUserDeviceResponse, err error) {
	response = CreateGetUserDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserDeviceWithChan invokes the csas.GetUserDevice API asynchronously
func (client *Client) GetUserDeviceWithChan(request *GetUserDeviceRequest) (<-chan *GetUserDeviceResponse, <-chan error) {
	responseChan := make(chan *GetUserDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserDeviceWithCallback invokes the csas.GetUserDevice API asynchronously
func (client *Client) GetUserDeviceWithCallback(request *GetUserDeviceRequest, callback func(response *GetUserDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserDeviceResponse
		var err error
		defer close(result)
		response, err = client.GetUserDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserDeviceRequest is the request struct for api GetUserDevice
type GetUserDeviceRequest struct {
	*requests.RpcRequest
	DeviceTag string `position:"Query" name:"DeviceTag"`
	SourceIp  string `position:"Query" name:"SourceIp"`
}

// GetUserDeviceResponse is the response struct for api GetUserDevice
type GetUserDeviceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Device    Device `json:"Device" xml:"Device"`
}

// CreateGetUserDeviceRequest creates a request to invoke GetUserDevice API
func CreateGetUserDeviceRequest() (request *GetUserDeviceRequest) {
	request = &GetUserDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "GetUserDevice", "", "")
	request.Method = requests.GET
	return
}

// CreateGetUserDeviceResponse creates a response to parse from GetUserDevice response
func CreateGetUserDeviceResponse() (response *GetUserDeviceResponse) {
	response = &GetUserDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
