package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDynamicRoute invokes the csas.DeleteDynamicRoute API synchronously
func (client *Client) DeleteDynamicRoute(request *DeleteDynamicRouteRequest) (response *DeleteDynamicRouteResponse, err error) {
	response = CreateDeleteDynamicRouteResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDynamicRouteWithChan invokes the csas.DeleteDynamicRoute API asynchronously
func (client *Client) DeleteDynamicRouteWithChan(request *DeleteDynamicRouteRequest) (<-chan *DeleteDynamicRouteResponse, <-chan error) {
	responseChan := make(chan *DeleteDynamicRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDynamicRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDynamicRouteWithCallback invokes the csas.DeleteDynamicRoute API asynchronously
func (client *Client) DeleteDynamicRouteWithCallback(request *DeleteDynamicRouteRequest, callback func(response *DeleteDynamicRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDynamicRouteResponse
		var err error
		defer close(result)
		response, err = client.DeleteDynamicRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDynamicRouteRequest is the request struct for api DeleteDynamicRoute
type DeleteDynamicRouteRequest struct {
	*requests.RpcRequest
	DynamicRouteId string `position:"Query" name:"DynamicRouteId"`
	SourceIp       string `position:"Query" name:"SourceIp"`
}

// DeleteDynamicRouteResponse is the response struct for api DeleteDynamicRoute
type DeleteDynamicRouteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDynamicRouteRequest creates a request to invoke DeleteDynamicRoute API
func CreateDeleteDynamicRouteRequest() (request *DeleteDynamicRouteRequest) {
	request = &DeleteDynamicRouteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "DeleteDynamicRoute", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDynamicRouteResponse creates a response to parse from DeleteDynamicRoute response
func CreateDeleteDynamicRouteResponse() (response *DeleteDynamicRouteResponse) {
	response = &DeleteDynamicRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
