package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePrivateAccessTag invokes the csas.CreatePrivateAccessTag API synchronously
func (client *Client) CreatePrivateAccessTag(request *CreatePrivateAccessTagRequest) (response *CreatePrivateAccessTagResponse, err error) {
	response = CreateCreatePrivateAccessTagResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePrivateAccessTagWithChan invokes the csas.CreatePrivateAccessTag API asynchronously
func (client *Client) CreatePrivateAccessTagWithChan(request *CreatePrivateAccessTagRequest) (<-chan *CreatePrivateAccessTagResponse, <-chan error) {
	responseChan := make(chan *CreatePrivateAccessTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePrivateAccessTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePrivateAccessTagWithCallback invokes the csas.CreatePrivateAccessTag API asynchronously
func (client *Client) CreatePrivateAccessTagWithCallback(request *CreatePrivateAccessTagRequest, callback func(response *CreatePrivateAccessTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePrivateAccessTagResponse
		var err error
		defer close(result)
		response, err = client.CreatePrivateAccessTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePrivateAccessTagRequest is the request struct for api CreatePrivateAccessTag
type CreatePrivateAccessTagRequest struct {
	*requests.RpcRequest
	Description string `position:"Body" name:"Description"`
	SourceIp    string `position:"Query" name:"SourceIp"`
	Name        string `position:"Body" name:"Name"`
}

// CreatePrivateAccessTagResponse is the response struct for api CreatePrivateAccessTag
type CreatePrivateAccessTagResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TagId     string `json:"TagId" xml:"TagId"`
}

// CreateCreatePrivateAccessTagRequest creates a request to invoke CreatePrivateAccessTag API
func CreateCreatePrivateAccessTagRequest() (request *CreatePrivateAccessTagRequest) {
	request = &CreatePrivateAccessTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "CreatePrivateAccessTag", "", "")
	request.Method = requests.POST
	return
}

// CreateCreatePrivateAccessTagResponse creates a response to parse from CreatePrivateAccessTag response
func CreateCreatePrivateAccessTagResponse() (response *CreatePrivateAccessTagResponse) {
	response = &CreatePrivateAccessTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
