package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResourcesByAdvancedSearch invokes the config.ListResourcesByAdvancedSearch API synchronously
func (client *Client) ListResourcesByAdvancedSearch(request *ListResourcesByAdvancedSearchRequest) (response *ListResourcesByAdvancedSearchResponse, err error) {
	response = CreateListResourcesByAdvancedSearchResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourcesByAdvancedSearchWithChan invokes the config.ListResourcesByAdvancedSearch API asynchronously
func (client *Client) ListResourcesByAdvancedSearchWithChan(request *ListResourcesByAdvancedSearchRequest) (<-chan *ListResourcesByAdvancedSearchResponse, <-chan error) {
	responseChan := make(chan *ListResourcesByAdvancedSearchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResourcesByAdvancedSearch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourcesByAdvancedSearchWithCallback invokes the config.ListResourcesByAdvancedSearch API asynchronously
func (client *Client) ListResourcesByAdvancedSearchWithCallback(request *ListResourcesByAdvancedSearchRequest, callback func(response *ListResourcesByAdvancedSearchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourcesByAdvancedSearchResponse
		var err error
		defer close(result)
		response, err = client.ListResourcesByAdvancedSearch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourcesByAdvancedSearchRequest is the request struct for api ListResourcesByAdvancedSearch
type ListResourcesByAdvancedSearchRequest struct {
	*requests.RpcRequest
	Sql string `position:"Query" name:"Sql"`
}

// ListResourcesByAdvancedSearchResponse is the response struct for api ListResourcesByAdvancedSearch
type ListResourcesByAdvancedSearchResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	QueryResults QueryResults `json:"QueryResults" xml:"QueryResults"`
}

// CreateListResourcesByAdvancedSearchRequest creates a request to invoke ListResourcesByAdvancedSearch API
func CreateListResourcesByAdvancedSearchRequest() (request *ListResourcesByAdvancedSearchRequest) {
	request = &ListResourcesByAdvancedSearchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListResourcesByAdvancedSearch", "", "")
	request.Method = requests.POST
	return
}

// CreateListResourcesByAdvancedSearchResponse creates a response to parse from ListResourcesByAdvancedSearch response
func CreateListResourcesByAdvancedSearchResponse() (response *ListResourcesByAdvancedSearchResponse) {
	response = &ListResourcesByAdvancedSearchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
