package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIntegratedServiceStatus invokes the config.GetIntegratedServiceStatus API synchronously
func (client *Client) GetIntegratedServiceStatus(request *GetIntegratedServiceStatusRequest) (response *GetIntegratedServiceStatusResponse, err error) {
	response = CreateGetIntegratedServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetIntegratedServiceStatusWithChan invokes the config.GetIntegratedServiceStatus API asynchronously
func (client *Client) GetIntegratedServiceStatusWithChan(request *GetIntegratedServiceStatusRequest) (<-chan *GetIntegratedServiceStatusResponse, <-chan error) {
	responseChan := make(chan *GetIntegratedServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIntegratedServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIntegratedServiceStatusWithCallback invokes the config.GetIntegratedServiceStatus API asynchronously
func (client *Client) GetIntegratedServiceStatusWithCallback(request *GetIntegratedServiceStatusRequest, callback func(response *GetIntegratedServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIntegratedServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.GetIntegratedServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIntegratedServiceStatusRequest is the request struct for api GetIntegratedServiceStatus
type GetIntegratedServiceStatusRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
}

// GetIntegratedServiceStatusResponse is the response struct for api GetIntegratedServiceStatus
type GetIntegratedServiceStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateGetIntegratedServiceStatusRequest creates a request to invoke GetIntegratedServiceStatus API
func CreateGetIntegratedServiceStatusRequest() (request *GetIntegratedServiceStatusRequest) {
	request = &GetIntegratedServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetIntegratedServiceStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateGetIntegratedServiceStatusResponse creates a response to parse from GetIntegratedServiceStatus response
func CreateGetIntegratedServiceStatusResponse() (response *GetIntegratedServiceStatusResponse) {
	response = &GetIntegratedServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
