package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCompliancePackReport invokes the config.GetCompliancePackReport API synchronously
func (client *Client) GetCompliancePackReport(request *GetCompliancePackReportRequest) (response *GetCompliancePackReportResponse, err error) {
	response = CreateGetCompliancePackReportResponse()
	err = client.DoAction(request, response)
	return
}

// GetCompliancePackReportWithChan invokes the config.GetCompliancePackReport API asynchronously
func (client *Client) GetCompliancePackReportWithChan(request *GetCompliancePackReportRequest) (<-chan *GetCompliancePackReportResponse, <-chan error) {
	responseChan := make(chan *GetCompliancePackReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCompliancePackReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCompliancePackReportWithCallback invokes the config.GetCompliancePackReport API asynchronously
func (client *Client) GetCompliancePackReportWithCallback(request *GetCompliancePackReportRequest, callback func(response *GetCompliancePackReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCompliancePackReportResponse
		var err error
		defer close(result)
		response, err = client.GetCompliancePackReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCompliancePackReportRequest is the request struct for api GetCompliancePackReport
type GetCompliancePackReportRequest struct {
	*requests.RpcRequest
	CompliancePackId string `position:"Query" name:"CompliancePackId"`
}

// GetCompliancePackReportResponse is the response struct for api GetCompliancePackReport
type GetCompliancePackReportResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	CompliancePackReport CompliancePackReport `json:"CompliancePackReport" xml:"CompliancePackReport"`
}

// CreateGetCompliancePackReportRequest creates a request to invoke GetCompliancePackReport API
func CreateGetCompliancePackReportRequest() (request *GetCompliancePackReportRequest) {
	request = &GetCompliancePackReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetCompliancePackReport", "", "")
	request.Method = requests.GET
	return
}

// CreateGetCompliancePackReportResponse creates a response to parse from GetCompliancePackReport response
func CreateGetCompliancePackReportResponse() (response *GetCompliancePackReportResponse) {
	response = &GetCompliancePackReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
