package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateService invokes the computenestsupplier.UpdateService API synchronously
func (client *Client) UpdateService(request *UpdateServiceRequest) (response *UpdateServiceResponse, err error) {
	response = CreateUpdateServiceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateServiceWithChan invokes the computenestsupplier.UpdateService API asynchronously
func (client *Client) UpdateServiceWithChan(request *UpdateServiceRequest) (<-chan *UpdateServiceResponse, <-chan error) {
	responseChan := make(chan *UpdateServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateServiceWithCallback invokes the computenestsupplier.UpdateService API asynchronously
func (client *Client) UpdateServiceWithCallback(request *UpdateServiceRequest, callback func(response *UpdateServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateServiceResponse
		var err error
		defer close(result)
		response, err = client.UpdateService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateServiceRequest is the request struct for api UpdateService
type UpdateServiceRequest struct {
	*requests.RpcRequest
	AlarmMetadata     string                      `position:"Query" name:"AlarmMetadata"`
	Resellable        requests.Boolean            `position:"Query" name:"Resellable"`
	ClientToken       string                      `position:"Query" name:"ClientToken"`
	PolicyNames       string                      `position:"Query" name:"PolicyNames"`
	LicenseMetadata   string                      `position:"Query" name:"LicenseMetadata"`
	Duration          requests.Integer            `position:"Query" name:"Duration"`
	TrialDuration     requests.Integer            `position:"Query" name:"TrialDuration"`
	UpgradeMetadata   string                      `position:"Query" name:"UpgradeMetadata"`
	DeployMetadata    string                      `position:"Query" name:"DeployMetadata"`
	ServiceType       string                      `position:"Query" name:"ServiceType"`
	IsSupportOperated requests.Boolean            `position:"Query" name:"IsSupportOperated"`
	TenantType        string                      `position:"Query" name:"TenantType"`
	ServiceVersion    string                      `position:"Query" name:"ServiceVersion"`
	LogMetadata       string                      `position:"Query" name:"LogMetadata"`
	ServiceInfo       *[]UpdateServiceServiceInfo `position:"Query" name:"ServiceInfo"  type:"Repeated"`
	UpdateOption      UpdateServiceUpdateOption   `position:"Query" name:"UpdateOption"  type:"Struct"`
	ServiceId         string                      `position:"Query" name:"ServiceId"`
	VersionName       string                      `position:"Query" name:"VersionName"`
	OperationMetadata string                      `position:"Query" name:"OperationMetadata"`
	DeployType        string                      `position:"Query" name:"DeployType"`
}

// UpdateServiceServiceInfo is a repeated param struct in UpdateServiceRequest
type UpdateServiceServiceInfo struct {
	ShortDescription   string                                `name:"ShortDescription"`
	Image              string                                `name:"Image"`
	Name               string                                `name:"Name"`
	Agreements         *[]UpdateServiceServiceInfoAgreements `name:"Agreements" type:"Repeated"`
	Locale             string                                `name:"Locale"`
	LongDescriptionUrl string                                `name:"LongDescriptionUrl"`
}

// UpdateServiceUpdateOption is a repeated param struct in UpdateServiceRequest
type UpdateServiceUpdateOption struct {
	UpdateFrom string `name:"UpdateFrom"`
}

// UpdateServiceServiceInfoAgreements is a repeated param struct in UpdateServiceRequest
type UpdateServiceServiceInfoAgreements struct {
	Name string `name:"Name"`
	Url  string `name:"Url"`
}

// UpdateServiceResponse is the response struct for api UpdateService
type UpdateServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateServiceRequest creates a request to invoke UpdateService API
func CreateUpdateServiceRequest() (request *UpdateServiceRequest) {
	request = &UpdateServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "UpdateService", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateServiceResponse creates a response to parse from UpdateService response
func CreateUpdateServiceResponse() (response *UpdateServiceResponse) {
	response = &UpdateServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
