package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetService invokes the computenestsupplier.GetService API synchronously
func (client *Client) GetService(request *GetServiceRequest) (response *GetServiceResponse, err error) {
	response = CreateGetServiceResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceWithChan invokes the computenestsupplier.GetService API asynchronously
func (client *Client) GetServiceWithChan(request *GetServiceRequest) (<-chan *GetServiceResponse, <-chan error) {
	responseChan := make(chan *GetServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceWithCallback invokes the computenestsupplier.GetService API asynchronously
func (client *Client) GetServiceWithCallback(request *GetServiceRequest, callback func(response *GetServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceResponse
		var err error
		defer close(result)
		response, err = client.GetService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceRequest is the request struct for api GetService
type GetServiceRequest struct {
	*requests.RpcRequest
	ShowDetail        *[]string        `position:"Query" name:"ShowDetail"  type:"Repeated"`
	SharedAccountType string           `position:"Query" name:"SharedAccountType"`
	FilterAliUid      requests.Boolean `position:"Query" name:"FilterAliUid"`
	ServiceVersion    string           `position:"Query" name:"ServiceVersion"`
	ServiceId         string           `position:"Query" name:"ServiceId"`
}

// GetServiceResponse is the response struct for api GetService
type GetServiceResponse struct {
	*responses.BaseResponse
	Status                      string                 `json:"Status" xml:"Status"`
	DeployMetadata              string                 `json:"DeployMetadata" xml:"DeployMetadata"`
	PublishTime                 string                 `json:"PublishTime" xml:"PublishTime"`
	RequestId                   string                 `json:"RequestId" xml:"RequestId"`
	Version                     string                 `json:"Version" xml:"Version"`
	DeployType                  string                 `json:"DeployType" xml:"DeployType"`
	ServiceId                   string                 `json:"ServiceId" xml:"ServiceId"`
	SupplierUrl                 string                 `json:"SupplierUrl" xml:"SupplierUrl"`
	ServiceDocUrl               string                 `json:"ServiceDocUrl" xml:"ServiceDocUrl"`
	ServiceProductUrl           string                 `json:"ServiceProductUrl" xml:"ServiceProductUrl"`
	ServiceType                 string                 `json:"ServiceType" xml:"ServiceType"`
	SupplierName                string                 `json:"SupplierName" xml:"SupplierName"`
	CommodityCode               string                 `json:"CommodityCode" xml:"CommodityCode"`
	IsSupportOperated           bool                   `json:"IsSupportOperated" xml:"IsSupportOperated"`
	PolicyNames                 string                 `json:"PolicyNames" xml:"PolicyNames"`
	Duration                    int64                  `json:"Duration" xml:"Duration"`
	Progress                    int64                  `json:"Progress" xml:"Progress"`
	StatusDetail                string                 `json:"StatusDetail" xml:"StatusDetail"`
	CreateTime                  string                 `json:"CreateTime" xml:"CreateTime"`
	UpdateTime                  string                 `json:"UpdateTime" xml:"UpdateTime"`
	ShareType                   string                 `json:"ShareType" xml:"ShareType"`
	AlarmMetadata               string                 `json:"AlarmMetadata" xml:"AlarmMetadata"`
	UpgradeMetadata             string                 `json:"UpgradeMetadata" xml:"UpgradeMetadata"`
	VersionName                 string                 `json:"VersionName" xml:"VersionName"`
	PayFromType                 string                 `json:"PayFromType" xml:"PayFromType"`
	PayType                     string                 `json:"PayType" xml:"PayType"`
	DefaultLicenseDays          int64                  `json:"DefaultLicenseDays" xml:"DefaultLicenseDays"`
	TrialDuration               int64                  `json:"TrialDuration" xml:"TrialDuration"`
	TrialType                   string                 `json:"TrialType" xml:"TrialType"`
	TenantType                  string                 `json:"TenantType" xml:"TenantType"`
	LicenseMetadata             string                 `json:"LicenseMetadata" xml:"LicenseMetadata"`
	OperationMetadata           string                 `json:"OperationMetadata" xml:"OperationMetadata"`
	TestStatus                  string                 `json:"TestStatus" xml:"TestStatus"`
	ApprovalType                string                 `json:"ApprovalType" xml:"ApprovalType"`
	RegistrationId              string                 `json:"RegistrationId" xml:"RegistrationId"`
	ResourceGroupId             string                 `json:"ResourceGroupId" xml:"ResourceGroupId"`
	Permission                  string                 `json:"Permission" xml:"Permission"`
	SourceServiceId             string                 `json:"SourceServiceId" xml:"SourceServiceId"`
	SourceServiceVersion        string                 `json:"SourceServiceVersion" xml:"SourceServiceVersion"`
	SourceSupplierName          string                 `json:"SourceSupplierName" xml:"SourceSupplierName"`
	LogMetadata                 string                 `json:"LogMetadata" xml:"LogMetadata"`
	Resellable                  bool                   `json:"Resellable" xml:"Resellable"`
	VirtualInternetService      string                 `json:"VirtualInternetService" xml:"VirtualInternetService"`
	ServiceDiscoverable         string                 `json:"ServiceDiscoverable" xml:"ServiceDiscoverable"`
	Categories                  string                 `json:"Categories" xml:"Categories"`
	ShareTypeStatus             string                 `json:"ShareTypeStatus" xml:"ShareTypeStatus"`
	ServiceAuditDocumentUrl     string                 `json:"ServiceAuditDocumentUrl" xml:"ServiceAuditDocumentUrl"`
	EntitySource                map[string]interface{} `json:"EntitySource" xml:"EntitySource"`
	CrossRegionConnectionStatus string                 `json:"CrossRegionConnectionStatus" xml:"CrossRegionConnectionStatus"`
	VirtualInternetServiceId    string                 `json:"VirtualInternetServiceId" xml:"VirtualInternetServiceId"`
	BuildInfo                   string                 `json:"BuildInfo" xml:"BuildInfo"`
	Statistic                   Statistic              `json:"Statistic" xml:"Statistic"`
	Commodity                   Commodity              `json:"Commodity" xml:"Commodity"`
	ServiceInfos                []ServiceInfo          `json:"ServiceInfos" xml:"ServiceInfos"`
	Tags                        []Tag                  `json:"Tags" xml:"Tags"`
}

// CreateGetServiceRequest creates a request to invoke GetService API
func CreateGetServiceRequest() (request *GetServiceRequest) {
	request = &GetServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "GetService", "", "")
	request.Method = requests.POST
	return
}

// CreateGetServiceResponse creates a response to parse from GetService response
func CreateGetServiceResponse() (response *GetServiceResponse) {
	response = &GetServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
