package computenest

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListServiceInstances invokes the computenest.ListServiceInstances API synchronously
func (client *Client) ListServiceInstances(request *ListServiceInstancesRequest) (response *ListServiceInstancesResponse, err error) {
	response = CreateListServiceInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// ListServiceInstancesWithChan invokes the computenest.ListServiceInstances API asynchronously
func (client *Client) ListServiceInstancesWithChan(request *ListServiceInstancesRequest) (<-chan *ListServiceInstancesResponse, <-chan error) {
	responseChan := make(chan *ListServiceInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListServiceInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListServiceInstancesWithCallback invokes the computenest.ListServiceInstances API asynchronously
func (client *Client) ListServiceInstancesWithCallback(request *ListServiceInstancesRequest, callback func(response *ListServiceInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListServiceInstancesResponse
		var err error
		defer close(result)
		response, err = client.ListServiceInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListServiceInstancesRequest is the request struct for api ListServiceInstances
type ListServiceInstancesRequest struct {
	*requests.RpcRequest
	ResourceGroupId string                        `position:"Query" name:"ResourceGroupId"`
	NextToken       string                        `position:"Query" name:"NextToken"`
	Tag             *[]ListServiceInstancesTag    `position:"Query" name:"Tag"  type:"Repeated"`
	Filter          *[]ListServiceInstancesFilter `position:"Query" name:"Filter"  type:"Repeated"`
	MaxResults      requests.Integer              `position:"Query" name:"MaxResults"`
}

// ListServiceInstancesTag is a repeated param struct in ListServiceInstancesRequest
type ListServiceInstancesTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// ListServiceInstancesFilter is a repeated param struct in ListServiceInstancesRequest
type ListServiceInstancesFilter struct {
	Name  string    `name:"Name"`
	Value *[]string `name:"Value" type:"Repeated"`
}

// ListServiceInstancesResponse is the response struct for api ListServiceInstances
type ListServiceInstancesResponse struct {
	*responses.BaseResponse
	NextToken        string            `json:"NextToken" xml:"NextToken"`
	RequestId        string            `json:"RequestId" xml:"RequestId"`
	TotalCount       int64             `json:"TotalCount" xml:"TotalCount"`
	MaxResults       int               `json:"MaxResults" xml:"MaxResults"`
	ServiceInstances []ServiceInstance `json:"ServiceInstances" xml:"ServiceInstances"`
}

// CreateListServiceInstancesRequest creates a request to invoke ListServiceInstances API
func CreateListServiceInstancesRequest() (request *ListServiceInstancesRequest) {
	request = &ListServiceInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNest", "2021-06-01", "ListServiceInstances", "computenest", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListServiceInstancesResponse creates a response to parse from ListServiceInstances response
func CreateListServiceInstancesResponse() (response *ListServiceInstancesResponse) {
	response = &ListServiceInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
