package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRepositoryCommits invokes the codeup.ListRepositoryCommits API synchronously
func (client *Client) ListRepositoryCommits(request *ListRepositoryCommitsRequest) (response *ListRepositoryCommitsResponse, err error) {
	response = CreateListRepositoryCommitsResponse()
	err = client.DoAction(request, response)
	return
}

// ListRepositoryCommitsWithChan invokes the codeup.ListRepositoryCommits API asynchronously
func (client *Client) ListRepositoryCommitsWithChan(request *ListRepositoryCommitsRequest) (<-chan *ListRepositoryCommitsResponse, <-chan error) {
	responseChan := make(chan *ListRepositoryCommitsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRepositoryCommits(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRepositoryCommitsWithCallback invokes the codeup.ListRepositoryCommits API asynchronously
func (client *Client) ListRepositoryCommitsWithCallback(request *ListRepositoryCommitsRequest, callback func(response *ListRepositoryCommitsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRepositoryCommitsResponse
		var err error
		defer close(result)
		response, err = client.ListRepositoryCommits(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRepositoryCommitsRequest is the request struct for api ListRepositoryCommits
type ListRepositoryCommitsRequest struct {
	*requests.RoaRequest
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ShowSignature  requests.Boolean `position:"Query" name:"ShowSignature"`
	RefName        string           `position:"Query" name:"RefName"`
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	Path           string           `position:"Query" name:"Path"`
	Search         string           `position:"Query" name:"Search"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	Page           requests.Integer `position:"Query" name:"Page"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// ListRepositoryCommitsResponse is the response struct for api ListRepositoryCommits
type ListRepositoryCommitsResponse struct {
	*responses.BaseResponse
	ErrorCode    string                              `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string                              `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string                              `json:"RequestId" xml:"RequestId"`
	Success      bool                                `json:"Success" xml:"Success"`
	Total        int64                               `json:"Total" xml:"Total"`
	Result       []ResultItemInListRepositoryCommits `json:"Result" xml:"Result"`
}

// CreateListRepositoryCommitsRequest creates a request to invoke ListRepositoryCommits API
func CreateListRepositoryCommitsRequest() (request *ListRepositoryCommitsRequest) {
	request = &ListRepositoryCommitsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "ListRepositoryCommits", "/api/v4/projects/[ProjectId]/repository/commits", "", "")
	request.Method = requests.GET
	return
}

// CreateListRepositoryCommitsResponse creates a response to parse from ListRepositoryCommits response
func CreateListRepositoryCommitsResponse() (response *ListRepositoryCommitsResponse) {
	response = &ListRepositoryCommitsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
