package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRepositoryMember invokes the codeup.DeleteRepositoryMember API synchronously
func (client *Client) DeleteRepositoryMember(request *DeleteRepositoryMemberRequest) (response *DeleteRepositoryMemberResponse, err error) {
	response = CreateDeleteRepositoryMemberResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRepositoryMemberWithChan invokes the codeup.DeleteRepositoryMember API asynchronously
func (client *Client) DeleteRepositoryMemberWithChan(request *DeleteRepositoryMemberRequest) (<-chan *DeleteRepositoryMemberResponse, <-chan error) {
	responseChan := make(chan *DeleteRepositoryMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRepositoryMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRepositoryMemberWithCallback invokes the codeup.DeleteRepositoryMember API asynchronously
func (client *Client) DeleteRepositoryMemberWithCallback(request *DeleteRepositoryMemberRequest, callback func(response *DeleteRepositoryMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRepositoryMemberResponse
		var err error
		defer close(result)
		response, err = client.DeleteRepositoryMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRepositoryMemberRequest is the request struct for api DeleteRepositoryMember
type DeleteRepositoryMemberRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	SubUserId      string           `position:"Query" name:"SubUserId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
	UserId         requests.Integer `position:"Path" name:"UserId"`
}

// DeleteRepositoryMemberResponse is the response struct for api DeleteRepositoryMember
type DeleteRepositoryMemberResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateDeleteRepositoryMemberRequest creates a request to invoke DeleteRepositoryMember API
func CreateDeleteRepositoryMemberRequest() (request *DeleteRepositoryMemberRequest) {
	request = &DeleteRepositoryMemberRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "DeleteRepositoryMember", "/api/v3/projects/[ProjectId]/members/[UserId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteRepositoryMemberResponse creates a response to parse from DeleteRepositoryMember response
func CreateDeleteRepositoryMemberResponse() (response *DeleteRepositoryMemberResponse) {
	response = &DeleteRepositoryMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
