package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutHybridMonitorMetricData invokes the cms.PutHybridMonitorMetricData API synchronously
func (client *Client) PutHybridMonitorMetricData(request *PutHybridMonitorMetricDataRequest) (response *PutHybridMonitorMetricDataResponse, err error) {
	response = CreatePutHybridMonitorMetricDataResponse()
	err = client.DoAction(request, response)
	return
}

// PutHybridMonitorMetricDataWithChan invokes the cms.PutHybridMonitorMetricData API asynchronously
func (client *Client) PutHybridMonitorMetricDataWithChan(request *PutHybridMonitorMetricDataRequest) (<-chan *PutHybridMonitorMetricDataResponse, <-chan error) {
	responseChan := make(chan *PutHybridMonitorMetricDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutHybridMonitorMetricData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutHybridMonitorMetricDataWithCallback invokes the cms.PutHybridMonitorMetricData API asynchronously
func (client *Client) PutHybridMonitorMetricDataWithCallback(request *PutHybridMonitorMetricDataRequest, callback func(response *PutHybridMonitorMetricDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutHybridMonitorMetricDataResponse
		var err error
		defer close(result)
		response, err = client.PutHybridMonitorMetricData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutHybridMonitorMetricDataRequest is the request struct for api PutHybridMonitorMetricData
type PutHybridMonitorMetricDataRequest struct {
	*requests.RpcRequest
	MetricList *[]PutHybridMonitorMetricDataMetricList `position:"Query" name:"MetricList"  type:"Repeated"`
	Namespace  string                                  `position:"Query" name:"Namespace"`
}

// PutHybridMonitorMetricDataMetricList is a repeated param struct in PutHybridMonitorMetricDataRequest
type PutHybridMonitorMetricDataMetricList struct {
	Name   string                                        `name:"Name"`
	Value  string                                        `name:"Value"`
	Labels *[]PutHybridMonitorMetricDataMetricListLabels `name:"Labels" type:"Repeated"`
	TS     string                                        `name:"TS"`
}

// PutHybridMonitorMetricDataMetricListLabels is a repeated param struct in PutHybridMonitorMetricDataRequest
type PutHybridMonitorMetricDataMetricListLabels struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// PutHybridMonitorMetricDataResponse is the response struct for api PutHybridMonitorMetricData
type PutHybridMonitorMetricDataResponse struct {
	*responses.BaseResponse
	Code        string   `json:"Code" xml:"Code"`
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	ErrorDetail []Detail `json:"ErrorDetail" xml:"ErrorDetail"`
}

// CreatePutHybridMonitorMetricDataRequest creates a request to invoke PutHybridMonitorMetricData API
func CreatePutHybridMonitorMetricDataRequest() (request *PutHybridMonitorMetricDataRequest) {
	request = &PutHybridMonitorMetricDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "PutHybridMonitorMetricData", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePutHybridMonitorMetricDataResponse creates a response to parse from PutHybridMonitorMetricData response
func CreatePutHybridMonitorMetricDataResponse() (response *PutHybridMonitorMetricDataResponse) {
	response = &PutHybridMonitorMetricDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
