package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyHybridMonitorTask invokes the cms.ModifyHybridMonitorTask API synchronously
func (client *Client) ModifyHybridMonitorTask(request *ModifyHybridMonitorTaskRequest) (response *ModifyHybridMonitorTaskResponse, err error) {
	response = CreateModifyHybridMonitorTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyHybridMonitorTaskWithChan invokes the cms.ModifyHybridMonitorTask API asynchronously
func (client *Client) ModifyHybridMonitorTaskWithChan(request *ModifyHybridMonitorTaskRequest) (<-chan *ModifyHybridMonitorTaskResponse, <-chan error) {
	responseChan := make(chan *ModifyHybridMonitorTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyHybridMonitorTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyHybridMonitorTaskWithCallback invokes the cms.ModifyHybridMonitorTask API asynchronously
func (client *Client) ModifyHybridMonitorTaskWithCallback(request *ModifyHybridMonitorTaskRequest, callback func(response *ModifyHybridMonitorTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyHybridMonitorTaskResponse
		var err error
		defer close(result)
		response, err = client.ModifyHybridMonitorTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyHybridMonitorTaskRequest is the request struct for api ModifyHybridMonitorTask
type ModifyHybridMonitorTaskRequest struct {
	*requests.RpcRequest
	LogSample             string                                  `position:"Query" name:"LogSample"`
	CollectTargetPath     string                                  `position:"Query" name:"CollectTargetPath"`
	Instances             *[]string                               `position:"Query" name:"Instances"  type:"Repeated"`
	LogSplit              string                                  `position:"Query" name:"LogSplit"`
	TaskName              string                                  `position:"Query" name:"TaskName"`
	Description           string                                  `position:"Query" name:"Description"`
	NetworkType           string                                  `position:"Query" name:"NetworkType"`
	ExtraInfo             string                                  `position:"Query" name:"ExtraInfo"`
	CollectInterval       string                                  `position:"Query" name:"CollectInterval"`
	AttachLabels          *[]ModifyHybridMonitorTaskAttachLabels  `position:"Query" name:"AttachLabels"  type:"Repeated"`
	UploadRegion          string                                  `position:"Query" name:"UploadRegion"`
	CollectTimout         string                                  `position:"Query" name:"CollectTimout"`
	TaskId                string                                  `position:"Query" name:"TaskId"`
	MatchExpressRelation  string                                  `position:"Query" name:"MatchExpressRelation"`
	LogProcess            string                                  `position:"Query" name:"LogProcess"`
	SLSProcess            string                                  `position:"Query" name:"SLSProcess"`
	CollectTargetEndpoint string                                  `position:"Query" name:"CollectTargetEndpoint"`
	YARMConfig            string                                  `position:"Query" name:"YARMConfig"`
	LogFilePath           string                                  `position:"Query" name:"LogFilePath"`
	MatchExpress          *[]ModifyHybridMonitorTaskMatchExpress  `position:"Query" name:"MatchExpress"  type:"Repeated"`
	SLSProcessConfig      ModifyHybridMonitorTaskSLSProcessConfig `position:"Query" name:"SLSProcessConfig"  type:"Struct"`
}

// ModifyHybridMonitorTaskAttachLabels is a repeated param struct in ModifyHybridMonitorTaskRequest
type ModifyHybridMonitorTaskAttachLabels struct {
	Name  string `name:"Name"`
	Value string `name:"Value"`
}

// ModifyHybridMonitorTaskMatchExpress is a repeated param struct in ModifyHybridMonitorTaskRequest
type ModifyHybridMonitorTaskMatchExpress struct {
	Function string `name:"Function"`
	Name     string `name:"Name"`
	Value    string `name:"Value"`
}

// ModifyHybridMonitorTaskSLSProcessConfig is a repeated param struct in ModifyHybridMonitorTaskRequest
type ModifyHybridMonitorTaskSLSProcessConfig struct {
	Filter     ModifyHybridMonitorTaskSLSProcessConfigFilter            `name:"Filter" type:"Struct"`
	Express    *[]ModifyHybridMonitorTaskSLSProcessConfigExpressItem    `name:"Express" type:"Repeated"`
	GroupBy    *[]ModifyHybridMonitorTaskSLSProcessConfigGroupByItem    `name:"GroupBy" type:"Repeated"`
	Statistics *[]ModifyHybridMonitorTaskSLSProcessConfigStatisticsItem `name:"Statistics" type:"Repeated"`
}

// ModifyHybridMonitorTaskSLSProcessConfigFilter is a repeated param struct in ModifyHybridMonitorTaskRequest
type ModifyHybridMonitorTaskSLSProcessConfigFilter struct {
	Filters  *[]ModifyHybridMonitorTaskSLSProcessConfigFilterFiltersItem `name:"Filters" type:"Repeated"`
	Relation string                                                      `name:"Relation"`
}

// ModifyHybridMonitorTaskSLSProcessConfigExpressItem is a repeated param struct in ModifyHybridMonitorTaskRequest
type ModifyHybridMonitorTaskSLSProcessConfigExpressItem struct {
	Alias   string `name:"Alias"`
	Express string `name:"Express"`
}

// ModifyHybridMonitorTaskSLSProcessConfigGroupByItem is a repeated param struct in ModifyHybridMonitorTaskRequest
type ModifyHybridMonitorTaskSLSProcessConfigGroupByItem struct {
	SLSKeyName string `name:"SLSKeyName"`
	Alias      string `name:"Alias"`
}

// ModifyHybridMonitorTaskSLSProcessConfigStatisticsItem is a repeated param struct in ModifyHybridMonitorTaskRequest
type ModifyHybridMonitorTaskSLSProcessConfigStatisticsItem struct {
	SLSKeyName string `name:"SLSKeyName"`
	Function   string `name:"Function"`
	Alias      string `name:"Alias"`
	Parameter2 string `name:"Parameter2"`
	Parameter1 string `name:"Parameter1"`
}

// ModifyHybridMonitorTaskSLSProcessConfigFilterFiltersItem is a repeated param struct in ModifyHybridMonitorTaskRequest
type ModifyHybridMonitorTaskSLSProcessConfigFilterFiltersItem struct {
	SLSKeyName string `name:"SLSKeyName"`
	Value      string `name:"Value"`
	Operator   string `name:"Operator"`
}

// ModifyHybridMonitorTaskResponse is the response struct for api ModifyHybridMonitorTask
type ModifyHybridMonitorTaskResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateModifyHybridMonitorTaskRequest creates a request to invoke ModifyHybridMonitorTask API
func CreateModifyHybridMonitorTaskRequest() (request *ModifyHybridMonitorTaskRequest) {
	request = &ModifyHybridMonitorTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "ModifyHybridMonitorTask", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyHybridMonitorTaskResponse creates a response to parse from ModifyHybridMonitorTask response
func CreateModifyHybridMonitorTaskResponse() (response *ModifyHybridMonitorTaskResponse) {
	response = &ModifyHybridMonitorTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
