package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RepairAp invokes the cloudwf.RepairAp API synchronously
// api document: https://help.aliyun.com/api/cloudwf/repairap.html
func (client *Client) RepairAp(request *RepairApRequest) (response *RepairApResponse, err error) {
	response = CreateRepairApResponse()
	err = client.DoAction(request, response)
	return
}

// RepairApWithChan invokes the cloudwf.RepairAp API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/repairap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RepairApWithChan(request *RepairApRequest) (<-chan *RepairApResponse, <-chan error) {
	responseChan := make(chan *RepairApResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RepairAp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RepairApWithCallback invokes the cloudwf.RepairAp API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/repairap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RepairApWithCallback(request *RepairApRequest, callback func(response *RepairApResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RepairApResponse
		var err error
		defer close(result)
		response, err = client.RepairAp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RepairApRequest is the request struct for api RepairAp
type RepairApRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// RepairApResponse is the response struct for api RepairAp
type RepairApResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateRepairApRequest creates a request to invoke RepairAp API
func CreateRepairApRequest() (request *RepairApRequest) {
	request = &RepairApRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "RepairAp", "cloudwf", "openAPI")
	return
}

// CreateRepairApResponse creates a response to parse from RepairAp response
func CreateRepairApResponse() (response *RepairApResponse) {
	response = &RepairApResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
