package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AreaShowList invokes the cloudwf.AreaShowList API synchronously
// api document: https://help.aliyun.com/api/cloudwf/areashowlist.html
func (client *Client) AreaShowList(request *AreaShowListRequest) (response *AreaShowListResponse, err error) {
	response = CreateAreaShowListResponse()
	err = client.DoAction(request, response)
	return
}

// AreaShowListWithChan invokes the cloudwf.AreaShowList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/areashowlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AreaShowListWithChan(request *AreaShowListRequest) (<-chan *AreaShowListResponse, <-chan error) {
	responseChan := make(chan *AreaShowListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AreaShowList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AreaShowListWithCallback invokes the cloudwf.AreaShowList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/areashowlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AreaShowListWithCallback(request *AreaShowListRequest, callback func(response *AreaShowListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AreaShowListResponse
		var err error
		defer close(result)
		response, err = client.AreaShowList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AreaShowListRequest is the request struct for api AreaShowList
type AreaShowListRequest struct {
	*requests.RpcRequest
	Page requests.Integer `position:"Query" name:"Page"`
	Per  requests.Integer `position:"Query" name:"Per"`
	Sid  requests.Integer `position:"Query" name:"Sid"`
}

// AreaShowListResponse is the response struct for api AreaShowList
type AreaShowListResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateAreaShowListRequest creates a request to invoke AreaShowList API
func CreateAreaShowListRequest() (request *AreaShowListRequest) {
	request = &AreaShowListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "AreaShowList", "cloudwf", "openAPI")
	return
}

// CreateAreaShowListResponse creates a response to parse from AreaShowList response
func CreateAreaShowListResponse() (response *AreaShowListResponse) {
	response = &AreaShowListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
