package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AreaInfo invokes the cloudwf.AreaInfo API synchronously
// api document: https://help.aliyun.com/api/cloudwf/areainfo.html
func (client *Client) AreaInfo(request *AreaInfoRequest) (response *AreaInfoResponse, err error) {
	response = CreateAreaInfoResponse()
	err = client.DoAction(request, response)
	return
}

// AreaInfoWithChan invokes the cloudwf.AreaInfo API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/areainfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AreaInfoWithChan(request *AreaInfoRequest) (<-chan *AreaInfoResponse, <-chan error) {
	responseChan := make(chan *AreaInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AreaInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AreaInfoWithCallback invokes the cloudwf.AreaInfo API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/areainfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AreaInfoWithCallback(request *AreaInfoRequest, callback func(response *AreaInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AreaInfoResponse
		var err error
		defer close(result)
		response, err = client.AreaInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AreaInfoRequest is the request struct for api AreaInfo
type AreaInfoRequest struct {
	*requests.RpcRequest
	Aid requests.Integer `position:"Query" name:"Aid"`
	Sid requests.Integer `position:"Query" name:"Sid"`
}

// AreaInfoResponse is the response struct for api AreaInfo
type AreaInfoResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateAreaInfoRequest creates a request to invoke AreaInfo API
func CreateAreaInfoRequest() (request *AreaInfoRequest) {
	request = &AreaInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "AreaInfo", "cloudwf", "openAPI")
	return
}

// CreateAreaInfoResponse creates a response to parse from AreaInfo response
func CreateAreaInfoResponse() (response *AreaInfoResponse) {
	response = &AreaInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
