package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FetchLibraries invokes the cloudphoto.FetchLibraries API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/fetchlibraries.html
func (client *Client) FetchLibraries(request *FetchLibrariesRequest) (response *FetchLibrariesResponse, err error) {
	response = CreateFetchLibrariesResponse()
	err = client.DoAction(request, response)
	return
}

// FetchLibrariesWithChan invokes the cloudphoto.FetchLibraries API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/fetchlibraries.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FetchLibrariesWithChan(request *FetchLibrariesRequest) (<-chan *FetchLibrariesResponse, <-chan error) {
	responseChan := make(chan *FetchLibrariesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FetchLibraries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FetchLibrariesWithCallback invokes the cloudphoto.FetchLibraries API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/fetchlibraries.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FetchLibrariesWithCallback(request *FetchLibrariesRequest, callback func(response *FetchLibrariesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FetchLibrariesResponse
		var err error
		defer close(result)
		response, err = client.FetchLibraries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FetchLibrariesRequest is the request struct for api FetchLibraries
type FetchLibrariesRequest struct {
	*requests.RpcRequest
	Size      requests.Integer `position:"Query" name:"Size"`
	StoreName string           `position:"Query" name:"StoreName"`
	Page      requests.Integer `position:"Query" name:"Page"`
}

// FetchLibrariesResponse is the response struct for api FetchLibraries
type FetchLibrariesResponse struct {
	*responses.BaseResponse
	Code       string    `json:"Code" xml:"Code"`
	Message    string    `json:"Message" xml:"Message"`
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	Action     string    `json:"Action" xml:"Action"`
	Libraries  []Library `json:"Libraries" xml:"Libraries"`
}

// CreateFetchLibrariesRequest creates a request to invoke FetchLibraries API
func CreateFetchLibrariesRequest() (request *FetchLibrariesRequest) {
	request = &FetchLibrariesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "FetchLibraries", "cloudphoto", "openAPI")
	return
}

// CreateFetchLibrariesResponse creates a response to parse from FetchLibraries response
func CreateFetchLibrariesResponse() (response *FetchLibrariesResponse) {
	response = &FetchLibrariesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
