package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutDisableFwSwitch invokes the cloudfw.PutDisableFwSwitch API synchronously
func (client *Client) PutDisableFwSwitch(request *PutDisableFwSwitchRequest) (response *PutDisableFwSwitchResponse, err error) {
	response = CreatePutDisableFwSwitchResponse()
	err = client.DoAction(request, response)
	return
}

// PutDisableFwSwitchWithChan invokes the cloudfw.PutDisableFwSwitch API asynchronously
func (client *Client) PutDisableFwSwitchWithChan(request *PutDisableFwSwitchRequest) (<-chan *PutDisableFwSwitchResponse, <-chan error) {
	responseChan := make(chan *PutDisableFwSwitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutDisableFwSwitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutDisableFwSwitchWithCallback invokes the cloudfw.PutDisableFwSwitch API asynchronously
func (client *Client) PutDisableFwSwitchWithCallback(request *PutDisableFwSwitchRequest, callback func(response *PutDisableFwSwitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutDisableFwSwitchResponse
		var err error
		defer close(result)
		response, err = client.PutDisableFwSwitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutDisableFwSwitchRequest is the request struct for api PutDisableFwSwitch
type PutDisableFwSwitchRequest struct {
	*requests.RpcRequest
	ResourceTypeList *[]string `position:"Query" name:"ResourceTypeList"  type:"Repeated"`
	SourceIp         string    `position:"Query" name:"SourceIp"`
	RegionList       *[]string `position:"Query" name:"RegionList"  type:"Repeated"`
	IpaddrList       *[]string `position:"Query" name:"IpaddrList"  type:"Repeated"`
	Lang             string    `position:"Query" name:"Lang"`
}

// PutDisableFwSwitchResponse is the response struct for api PutDisableFwSwitch
type PutDisableFwSwitchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePutDisableFwSwitchRequest creates a request to invoke PutDisableFwSwitch API
func CreatePutDisableFwSwitchRequest() (request *PutDisableFwSwitchRequest) {
	request = &PutDisableFwSwitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "PutDisableFwSwitch", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePutDisableFwSwitchResponse creates a response to parse from PutDisableFwSwitch response
func CreatePutDisableFwSwitchResponse() (response *PutDisableFwSwitchResponse) {
	response = &PutDisableFwSwitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
