package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceMemberAttributes invokes the cloudfw.ModifyInstanceMemberAttributes API synchronously
func (client *Client) ModifyInstanceMemberAttributes(request *ModifyInstanceMemberAttributesRequest) (response *ModifyInstanceMemberAttributesResponse, err error) {
	response = CreateModifyInstanceMemberAttributesResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceMemberAttributesWithChan invokes the cloudfw.ModifyInstanceMemberAttributes API asynchronously
func (client *Client) ModifyInstanceMemberAttributesWithChan(request *ModifyInstanceMemberAttributesRequest) (<-chan *ModifyInstanceMemberAttributesResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceMemberAttributesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceMemberAttributes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceMemberAttributesWithCallback invokes the cloudfw.ModifyInstanceMemberAttributes API asynchronously
func (client *Client) ModifyInstanceMemberAttributesWithCallback(request *ModifyInstanceMemberAttributesRequest, callback func(response *ModifyInstanceMemberAttributesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceMemberAttributesResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceMemberAttributes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceMemberAttributesRequest is the request struct for api ModifyInstanceMemberAttributes
type ModifyInstanceMemberAttributesRequest struct {
	*requests.RpcRequest
	SourceIp string                                   `position:"Query" name:"SourceIp"`
	Members  *[]ModifyInstanceMemberAttributesMembers `position:"Query" name:"Members"  type:"Repeated"`
	Lang     string                                   `position:"Query" name:"Lang"`
}

// ModifyInstanceMemberAttributesMembers is a repeated param struct in ModifyInstanceMemberAttributesRequest
type ModifyInstanceMemberAttributesMembers struct {
	MemberUid  string `name:"MemberUid"`
	MemberDesc string `name:"MemberDesc"`
}

// ModifyInstanceMemberAttributesResponse is the response struct for api ModifyInstanceMemberAttributes
type ModifyInstanceMemberAttributesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyInstanceMemberAttributesRequest creates a request to invoke ModifyInstanceMemberAttributes API
func CreateModifyInstanceMemberAttributesRequest() (request *ModifyInstanceMemberAttributesRequest) {
	request = &ModifyInstanceMemberAttributesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyInstanceMemberAttributes", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyInstanceMemberAttributesResponse creates a response to parse from ModifyInstanceMemberAttributes response
func CreateModifyInstanceMemberAttributesResponse() (response *ModifyInstanceMemberAttributesResponse) {
	response = &ModifyInstanceMemberAttributesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
